/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.pipeline;

import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.attribute.BufferVertexFormat;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.VertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.type.BlittableVertexType;
import me.jellysquid.mods.sodium.client.model.vertex.type.VertexType;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
implements VertexBufferView,
VertexDrain {
    @Shadow
    private int f_85652_;
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    @Final
    private static Logger f_85647_;
    @Shadow
    private VertexFormat f_85658_;
    @Shadow
    private int f_85654_;

    @Shadow
    private static int m_85725_(int amount) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"popData"}, at=@At(value="INVOKE", target="Ljava/nio/ByteBuffer;limit(I)Ljava/nio/ByteBuffer;"))
    public ByteBuffer debugGetNextBuffer(ByteBuffer buffer, int newLimit) {
        this.ensureBufferCapacity(newLimit);
        buffer = this.f_85648_;
        buffer.limit(newLimit);
        return buffer;
    }

    @Override
    public boolean ensureBufferCapacity(int bytes) {
        if (this.f_85658_ == null) {
            return false;
        }
        if (this.f_85652_ + (bytes += this.f_85658_.m_86020_()) <= this.f_85648_.capacity()) {
            return false;
        }
        int newSize = this.f_85648_.capacity() + MixinBufferBuilder.m_85725_(bytes);
        f_85647_.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)this.f_85648_.capacity(), (Object)newSize);
        this.f_85648_.position(0);
        ByteBuffer byteBuffer = MemoryTracker.m_182527_((int)newSize);
        byteBuffer.put(this.f_85648_);
        byteBuffer.rewind();
        this.f_85648_ = byteBuffer;
        return true;
    }

    @Override
    public ByteBuffer getDirectBuffer() {
        return this.f_85648_;
    }

    @Override
    public int getWriterPosition() {
        return this.f_85652_;
    }

    @Override
    public BufferVertexFormat getVertexFormat() {
        return BufferVertexFormat.from(this.f_85658_);
    }

    @Override
    public void flush(int vertexCount, BufferVertexFormat format) {
        if (BufferVertexFormat.from(this.f_85658_) != format) {
            throw new IllegalStateException("Mis-matched vertex format (expected: [" + format + "], currently using: [" + this.f_85658_ + "])");
        }
        this.f_85654_ += vertexCount;
        this.f_85652_ += vertexCount * format.getStride();
    }

    @Override
    public <T extends VertexSink> T createSink(VertexType<T> factory) {
        BlittableVertexType<T> blittable = factory.asBlittable();
        if (blittable != null && blittable.getBufferVertexFormat() == this.getVertexFormat()) {
            return blittable.createBufferWriter(this, SodiumClientMod.isDirectMemoryAccessEnabled());
        }
        return factory.createFallbackWriter((VertexConsumer)this);
    }
}

