/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.BeyondEarthMod;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capabilities.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.config.Config;
import net.mrscauthd.beyond_earth.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.entities.LanderEntity;
import net.mrscauthd.beyond_earth.entities.VehicleEntity;
import net.mrscauthd.beyond_earth.events.forge.LanderOrbitTeleportEvent;
import net.mrscauthd.beyond_earth.events.forge.LivingSetFireInHotPlanetEvent;
import net.mrscauthd.beyond_earth.events.forge.LivingSetVenusRainEvent;
import net.mrscauthd.beyond_earth.events.forge.PlayerExitPlanetSelectionGuiEvent;
import net.mrscauthd.beyond_earth.events.forge.StartRideLanderEvent;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.beyond_earth.items.VehicleItem;
import net.mrscauthd.beyond_earth.registries.DamageSourcesRegistry;
import net.mrscauthd.beyond_earth.registries.EffectsRegistry;
import net.mrscauthd.beyond_earth.registries.EntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.registries.SoundsRegistry;
import net.mrscauthd.beyond_earth.registries.TagsRegistry;

public class Methods {
    public static final ResourceKey<Level> moon = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "moon"));
    public static final ResourceKey<Level> moon_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "moon_orbit"));
    public static final ResourceKey<Level> mars = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mars"));
    public static final ResourceKey<Level> mars_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mars_orbit"));
    public static final ResourceKey<Level> mercury = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mercury"));
    public static final ResourceKey<Level> mercury_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "mercury_orbit"));
    public static final ResourceKey<Level> venus = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "venus"));
    public static final ResourceKey<Level> venus_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "venus_orbit"));
    public static final ResourceKey<Level> glacio = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "glacio"));
    public static final ResourceKey<Level> glacio_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "glacio_orbit"));
    public static final ResourceKey<Level> overworld = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("overworld"));
    public static final ResourceKey<Level> earth_orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("beyond_earth", "earth_orbit"));
    public static final ResourceLocation space_station = new ResourceLocation("beyond_earth", "space_station");
    public static final Set<ResourceKey<Level>> worldsWithoutRain = Set.of(moon, moon_orbit, mars_orbit, mercury, mercury_orbit, venus_orbit, glacio_orbit, earth_orbit);
    public static final Set<ResourceKey<Level>> spaceWorldsWithoutOxygen = Set.of(moon, moon_orbit, mars, mars_orbit, mercury, mercury_orbit, venus, venus_orbit, glacio_orbit, earth_orbit);
    public static final Set<ResourceKey<Level>> spaceWorlds = Set.of(moon, moon_orbit, mars, mars_orbit, mercury, mercury_orbit, venus, venus_orbit, glacio, glacio_orbit, earth_orbit);
    private static final Set<ResourceKey<Level>> orbitWorlds = Set.of(earth_orbit, moon_orbit, mars_orbit, mercury_orbit, venus_orbit, glacio_orbit);

    public static void entityWorldTeleporter(Entity entity, ResourceKey<Level> planet, final double high) {
        if (entity.m_6072_()) {
            if (entity.m_20194_() == null) {
                return;
            }
            ServerLevel nextLevel = entity.m_20194_().m_129880_(planet);
            if (nextLevel == null) {
                BeyondEarthMod.LOGGER.error(planet.getRegistryName() + " not existing!");
                return;
            }
            entity.changeDimension(nextLevel, new ITeleporter(){

                public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                    Vec3 pos = new Vec3(entity.m_20182_().f_82479_, high, entity.m_20182_().f_82481_);
                    return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
                }

                public boolean isVanilla() {
                    return false;
                }

                public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                    return false;
                }
            });
        }
    }

    public static boolean netheriteSpaceSuitCheck(LivingEntity entity) {
        if (!Methods.checkArmor(entity, 3, (Item)ItemsRegistry.NETHERITE_OXYGEN_MASK.get())) {
            return false;
        }
        if (!Methods.checkArmor(entity, 2, (Item)ItemsRegistry.NETHERITE_SPACE_SUIT.get())) {
            return false;
        }
        if (!Methods.checkArmor(entity, 1, (Item)ItemsRegistry.NETHERITE_SPACE_PANTS.get())) {
            return false;
        }
        return Methods.checkArmor(entity, 0, (Item)ItemsRegistry.NETHERITE_SPACE_BOOTS.get());
    }

    public static boolean spaceSuitCheck(LivingEntity entity) {
        if (!Methods.checkArmor(entity, 3, (Item)ItemsRegistry.OXYGEN_MASK.get())) {
            return false;
        }
        if (!Methods.checkArmor(entity, 2, (Item)ItemsRegistry.SPACE_SUIT.get())) {
            return false;
        }
        if (!Methods.checkArmor(entity, 1, (Item)ItemsRegistry.SPACE_PANTS.get())) {
            return false;
        }
        return Methods.checkArmor(entity, 0, (Item)ItemsRegistry.SPACE_BOOTS.get());
    }

    public static boolean spaceSuitCheckBoth(LivingEntity entity) {
        boolean item3 = Methods.checkArmor(entity, 3, (Item)ItemsRegistry.OXYGEN_MASK.get());
        boolean item3b = Methods.checkArmor(entity, 3, (Item)ItemsRegistry.NETHERITE_OXYGEN_MASK.get());
        if (!item3 && !item3b) {
            return false;
        }
        boolean item2 = Methods.checkArmor(entity, 2, (Item)ItemsRegistry.SPACE_SUIT.get());
        boolean item2b = Methods.checkArmor(entity, 2, (Item)ItemsRegistry.NETHERITE_SPACE_SUIT.get());
        if (!item2 && !item2b) {
            return false;
        }
        boolean item1 = Methods.checkArmor(entity, 1, (Item)ItemsRegistry.SPACE_PANTS.get());
        boolean item1b = Methods.checkArmor(entity, 1, (Item)ItemsRegistry.NETHERITE_SPACE_PANTS.get());
        if (!item1 && !item1b) {
            return false;
        }
        boolean item0 = Methods.checkArmor(entity, 0, (Item)ItemsRegistry.SPACE_BOOTS.get());
        boolean item0b = Methods.checkArmor(entity, 0, (Item)ItemsRegistry.NETHERITE_SPACE_BOOTS.get());
        return item0 || item0b;
    }

    public static boolean checkArmor(LivingEntity entity, int number, Item item) {
        return entity.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)number)).m_41720_() == item;
    }

    public static boolean isSpaceWorld(Level world) {
        return spaceWorlds.contains(world.m_46472_());
    }

    public static boolean isSpaceWorldWithoutOxygen(Level world) {
        return spaceWorldsWithoutOxygen.contains(world.m_46472_());
    }

    public static boolean isOrbitWorld(Level world) {
        return orbitWorlds.contains(world.m_46472_());
    }

    public static boolean isWorld(Level world, ResourceKey<Level> loc) {
        return world.m_46472_() == loc;
    }

    public static void oxygenDamage(LivingEntity entity) {
        entity.m_6469_(DamageSourcesRegistry.DAMAGE_SOURCE_OXYGEN, 1.0f);
    }

    public static void venusRainDamage(LivingEntity entity) {
        entity.m_6469_(DamageSourcesRegistry.DAMAGE_SOURCE_ACID_RAIN, 1.0f);
    }

    public static boolean isRocket(Entity entity) {
        return entity instanceof IRocketEntity;
    }

    public static boolean isVehicle(Entity entity) {
        return entity instanceof VehicleEntity;
    }

    public static void dropRocket(Player player) {
        Item item1 = player.m_21205_().m_41720_();
        Item item2 = player.m_21206_().m_41720_();
        if (item1 instanceof VehicleItem && item2 instanceof VehicleItem) {
            ItemEntity spawn = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)item2));
            spawn.m_32010_(0);
            player.f_19853_.m_7967_((Entity)spawn);
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(capability -> capability.extractItem(40, 1, false));
        }
    }

    public static void planetFire(LivingEntity entity, ResourceKey<Level> planet) {
        Player player;
        Level level = entity.f_19853_;
        if (!Methods.isWorld(level, planet)) {
            return;
        }
        if ((entity instanceof Mob || entity instanceof Player) && (Methods.netheriteSpaceSuitCheck(entity) || entity.m_21023_(MobEffects.f_19607_) || entity.m_5825_())) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_150110_().f_35937_)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSetFireInHotPlanetEvent(entity, planet))) {
            return;
        }
        if (Methods.tagCheck((Entity)entity, TagsRegistry.PLANET_FIRE_TAG)) {
            return;
        }
        entity.m_20254_(10);
    }

    public static void venusRain(LivingEntity entity, ResourceKey<Level> planet) {
        Player player;
        if (!Methods.isWorld(entity.f_19853_, planet)) {
            return;
        }
        if (entity.m_20159_() && (Methods.isRocket(entity.m_20202_()) || entity.m_20202_() instanceof LanderEntity)) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_150110_().f_35937_)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSetVenusRainEvent(entity, planet))) {
            return;
        }
        if (Methods.tagCheck((Entity)entity, TagsRegistry.VENUS_RAIN_TAG)) {
            return;
        }
        if (entity.f_19853_.m_6106_().m_6533_() && (double)entity.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(entity.m_20185_()), (int)Math.floor(entity.m_20189_())) <= Math.floor(entity.m_20186_()) + 1.0 && !entity.f_19853_.f_46443_) {
            Methods.venusRainDamage(entity);
        }
    }

    public static void entityOxygen(LivingEntity entity, Level level) {
        if (entity instanceof Player) {
            return;
        }
        if (((Boolean)Config.ENTITY_OXYGEN_SYSTEM.get()).booleanValue() && Methods.isSpaceWorldWithoutOxygen(level) && Methods.tagCheck((Entity)entity, TagsRegistry.OXYGEN_TAG) && !entity.m_21023_((MobEffect)EffectsRegistry.OXYGEN_EFFECT.get())) {
            entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") + 1.0);
            if (entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") > 15.0) {
                if (!level.f_46443_) {
                    Methods.oxygenDamage(entity);
                }
                entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", 0.0);
            }
        }
        if (((Boolean)Config.ENTITY_OXYGEN_SYSTEM.get()).booleanValue() && entity.m_21023_((MobEffect)EffectsRegistry.OXYGEN_EFFECT.get())) {
            entity.m_20301_(300);
        }
    }

    public static void vehicleRotation(Entity vehicle, float rotation) {
        vehicle.m_146922_(vehicle.m_146908_() + rotation);
        vehicle.m_5618_(vehicle.m_146908_());
        vehicle.f_19859_ = vehicle.m_146908_();
    }

    public static boolean tagCheck(Entity entity, TagKey<EntityType<?>> tag) {
        return entity.m_6095_().m_204039_(tag);
    }

    public static boolean tagCheck(Fluid fluid, TagKey<Fluid> tag) {
        return fluid.m_205067_(tag);
    }

    public static boolean tagCheck(ItemStack item, TagKey<Item> tag) {
        return item.m_204117_(tag);
    }

    public static void landerTeleport(Player player, ResourceKey<Level> newPlanet) {
        LanderEntity lander = (LanderEntity)player.m_20202_();
        if (lander.m_20186_() < 1.0) {
            MinecraftForge.EVENT_BUS.post((Event)new LanderOrbitTeleportEvent.Pre(lander, player));
            ItemStack slot_0 = lander.getInventory().getStackInSlot(0);
            ItemStack slot_1 = lander.getInventory().getStackInSlot(1);
            if (!player.f_19853_.f_46443_) {
                lander.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            Methods.entityWorldTeleporter((Entity)player, newPlanet, 700.0);
            Level newWorld = player.f_19853_;
            if (!player.f_19853_.f_46443_) {
                LanderEntity entityToSpawn = new LanderEntity((EntityType)EntitiesRegistry.LANDER.get(), newWorld);
                entityToSpawn.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                newWorld.m_7967_((Entity)entityToSpawn);
                entityToSpawn.getInventory().setStackInSlot(0, slot_0);
                entityToSpawn.getInventory().setStackInSlot(1, slot_1);
                player.m_20329_((Entity)entityToSpawn);
                MinecraftForge.EVENT_BUS.post((Event)new LanderOrbitTeleportEvent.Post(lander, player));
            }
        }
    }

    public static void rocketTeleport(Player player, ResourceKey<Level> planet, ItemStack rocketItem, Boolean SpaceStation) {
        Level level = player.f_19853_;
        if (!Methods.isWorld(level, planet)) {
            Methods.entityWorldTeleporter((Entity)player, planet, 700.0);
        } else {
            player.m_6034_(player.m_20185_(), 700.0, player.m_20189_());
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.m_9774_(player.m_20185_(), 700.0, player.m_20189_(), player.m_146908_(), player.m_146909_());
            }
        }
        Level newLevel = player.f_19853_;
        if (!newLevel.f_46443_) {
            LanderEntity landerSpawn = new LanderEntity((EntityType)EntitiesRegistry.LANDER.get(), newLevel);
            landerSpawn.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
            newLevel.m_7967_((Entity)landerSpawn);
            String itemId = player.getPersistentData().m_128461_("beyond_earth:slot0");
            landerSpawn.getInventory().setStackInSlot(0, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), 1));
            landerSpawn.getInventory().setStackInSlot(1, rocketItem);
            if (SpaceStation.booleanValue()) {
                Methods.createSpaceStation(player, (ServerLevel)newLevel);
            }
            MinecraftForge.EVENT_BUS.post((Event)new StartRideLanderEvent(landerSpawn, player));
            Methods.cleanUpPlayerNBT(player);
            player.m_20329_((Entity)landerSpawn);
        }
    }

    public static void createSpaceStation(Player player, ServerLevel serverWorld) {
        BlockPos pos = new BlockPos(player.m_20185_() - 15.5, 100.0, player.m_20189_() - 15.5);
        serverWorld.m_8875_().m_74341_(space_station).m_74536_((ServerLevelAccessor)serverWorld, pos, pos, new StructurePlaceSettings(), serverWorld.f_46441_, 2);
    }

    public static void cleanUpPlayerNBT(Player player) {
        player.getPersistentData().m_128379_("beyond_earth:planet_selection_gui_open", false);
        player.getPersistentData().m_128359_("beyond_earth:rocket_type", "");
        player.getPersistentData().m_128359_("beyond_earth:slot0", "");
        MinecraftForge.EVENT_BUS.post((Event)new PlayerExitPlanetSelectionGuiEvent(player));
    }

    public static void openPlanetGui(Player player) {
        if (!(player.f_36096_ instanceof PlanetSelectionGui.GuiContainer) && player.getPersistentData().m_128471_("beyond_earth:planet_selection_gui_open") && player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Planet Selection");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130070_(player.getPersistentData().m_128461_("beyond_earth:rocket_type"));
                    return new PlanetSelectionGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.m_130070_(player.getPersistentData().m_128461_("beyond_earth:rocket_type")));
        }
    }

    public static void teleportButton(Player player, ResourceKey<Level> planet, boolean SpaceStation) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_41852_, 1);
        if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t1")) {
            itemStack = new ItemStack((ItemLike)ItemsRegistry.TIER_1_ROCKET_ITEM.get(), 1);
        } else if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t2")) {
            itemStack = new ItemStack((ItemLike)ItemsRegistry.TIER_2_ROCKET_ITEM.get(), 1);
        } else if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t3")) {
            itemStack = new ItemStack((ItemLike)ItemsRegistry.TIER_3_ROCKET_ITEM.get(), 1);
        } else if (player.getPersistentData().m_128461_("beyond_earth:rocket_type").equals("entity.beyond_earth.rocket_t4")) {
            itemStack = new ItemStack((ItemLike)ItemsRegistry.TIER_4_ROCKET_ITEM.get(), 1);
        }
        Methods.rocketTeleport(player, planet, itemStack, SpaceStation);
    }

    public static void landerTeleportOrbit(Player player, Level world) {
        if (Methods.isWorld(world, earth_orbit)) {
            Methods.landerTeleport(player, overworld);
        } else if (Methods.isWorld(world, moon_orbit)) {
            Methods.landerTeleport(player, moon);
        } else if (Methods.isWorld(world, mars_orbit)) {
            Methods.landerTeleport(player, mars);
        } else if (Methods.isWorld(world, glacio_orbit)) {
            Methods.landerTeleport(player, glacio);
        } else if (Methods.isWorld(world, mercury_orbit)) {
            Methods.landerTeleport(player, mercury);
        } else if (Methods.isWorld(world, venus_orbit)) {
            Methods.landerTeleport(player, venus);
        }
    }

    public static void entityFallToPlanet(Level world, Entity entity) {
        ResourceKey world2 = world.m_46472_();
        if (world2 == earth_orbit) {
            Methods.entityWorldTeleporter(entity, overworld, 450.0);
        } else if (world2 == moon_orbit) {
            Methods.entityWorldTeleporter(entity, moon, 450.0);
        } else if (world2 == mars_orbit) {
            Methods.entityWorldTeleporter(entity, mars, 450.0);
        } else if (world2 == mercury_orbit) {
            Methods.entityWorldTeleporter(entity, mercury, 450.0);
        } else if (world2 == venus_orbit) {
            Methods.entityWorldTeleporter(entity, venus, 450.0);
        } else if (world2 == glacio_orbit) {
            Methods.entityWorldTeleporter(entity, glacio, 450.0);
        }
    }

    public static void extractArmorOxygenUsingTimer(ItemStack itemstack, Player player) {
        if (!player.m_150110_().f_35937_ && !player.m_5833_() && Methods.spaceSuitCheckBoth((LivingEntity)player) && !player.m_21023_((MobEffect)EffectsRegistry.OXYGEN_EFFECT.get()) && ((Boolean)Config.PLAYER_OXYGEN_SYSTEM.get()).booleanValue() && (Methods.isSpaceWorldWithoutOxygen(player.f_19853_) || player.m_204029_(FluidTags.f_13131_))) {
            IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(itemstack);
            CompoundTag persistentData = player.getPersistentData();
            String key = "beyond_earth:oxygen_timer";
            int oxygenTimer = persistentData.m_128451_(key);
            if (oxygenStorage.getOxygenStored() > 0 && ++oxygenTimer > 3) {
                oxygenStorage.extractOxygen(1, false);
                oxygenTimer = 0;
            }
            persistentData.m_128405_(key, oxygenTimer);
        }
    }

    public static void disableFlyAntiCheat(ServerPlayer player, boolean condition) {
        if (condition) {
            player.f_8906_.f_9737_ = 0;
        }
    }

    public static void rocketSounds(Entity entity, Level world) {
        world.m_6269_(null, entity, (SoundEvent)SoundsRegistry.ROCKET_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void noFuelMessage(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent("message.beyond_earth.no_fuel"), false);
        }
    }

    public static void holdSpaceMessage(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent("message.beyond_earth.hold_space"), false);
        }
    }
}

