/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.globe;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mrscauthd.beyond_earth.globe.GlobeTileEntity;

public class GlobeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = Shapes.m_83048_((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)1.0, (double)0.8);

    public GlobeBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState p_49325_, LevelReader p_49326_, BlockPos p_49327_) {
        BlockPos blockpos = p_49327_.m_7495_();
        return GlobeBlock.m_49936_((BlockGetter)p_49326_, (BlockPos)blockpos) || GlobeBlock.m_49863_((LevelReader)p_49326_, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public BlockState m_6843_(BlockState p_48811_, Rotation p_48812_) {
        return (BlockState)p_48811_.m_61124_((Property)FACING, (Comparable)p_48812_.m_55954_((Direction)p_48811_.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState p_56285_, Direction p_56286_, BlockState p_56287_, LevelAccessor p_56288_, BlockPos p_56289_, BlockPos p_56290_) {
        if (((Boolean)p_56285_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_56288_.m_186469_(p_56289_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_56288_));
        }
        return p_56286_ == Direction.DOWN && !p_56285_.m_60710_((LevelReader)p_56288_, p_56289_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_56285_, p_56286_, p_56287_, p_56288_, p_56289_, p_56290_);
    }

    public FluidState m_5888_(BlockState p_56299_) {
        return (Boolean)p_56299_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56299_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new GlobeTileEntity(p_153215_, p_153216_);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.f_46443_ && p_60504_.m_7702_(p_60505_) instanceof GlobeTileEntity) {
            GlobeTileEntity blockEntity = (GlobeTileEntity)p_60504_.m_7702_(p_60505_);
            float value = (float)(Math.PI / (Math.pow(3.0E-5, blockEntity.getRotationalInertia()) + 1.0) / 4.0);
            blockEntity.setRotationalInertia(value);
            blockEntity.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public <T2 extends BlockEntity> BlockEntityTicker<T2> m_142354_(Level level, BlockState state, BlockEntityType<T2> type) {
        return (l, p, s, e) -> {
            if (e instanceof GlobeTileEntity) {
                ((GlobeTileEntity)e).tick();
            }
        };
    }
}

