/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.skyrenderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.mrscauthd.beyond_earth.skyrenderers.helper.StarHelper;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MarsOrbitSky {
    private static final ResourceLocation DIM_RENDER_INFO = new ResourceLocation("beyond_earth", "mars_orbit");
    @Nullable
    public static VertexBuffer starBuffer;
    private static final ResourceLocation MARS_TEXTURE;
    private static final ResourceLocation SUN_TEXTURE;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientSetup(FMLClientSetupEvent event) {
        DimensionSpecialEffects.f_108857_.put((Object)DIM_RENDER_INFO, (Object)new DimensionSpecialEffects(192.0f, false, DimensionSpecialEffects.SkyType.NORMAL, false, false){

            public Vec3 m_5927_(Vec3 p_108878_, float p_108879_) {
                return p_108878_;
            }

            public boolean m_5781_(int p_108874_, int p_108875_) {
                return false;
            }

            public ICloudRenderHandler getCloudRenderHandler() {
                return new ICloudRenderHandler(){

                    public void render(int ticks, float partialTicks, PoseStack matrixStack, ClientLevel world, Minecraft mc, double viewEntityX, double viewEntityY, double viewEntityZ) {
                    }
                };
            }

            public float[] m_7518_(float p_108872_, float p_108873_) {
                return null;
            }

            public ISkyRenderHandler getSkyRenderHandler() {
                return new ISkyRenderHandler(){

                    public void render(int ticks, float p_181412_, PoseStack p_181410_, ClientLevel level, Minecraft minecraft) {
                        Camera camera = minecraft.f_91063_.m_109153_();
                        FogType fogtype = camera.m_167685_();
                        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA) {
                            LivingEntity livingentity;
                            Entity entity = camera.m_90592_();
                            if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_)) {
                                return;
                            }
                            Matrix4f matrix4f = RenderSystem.m_157192_();
                            Matrix4f starMatrix4f = RenderSystem.m_157192_();
                            RenderSystem.m_69472_();
                            Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), p_181412_);
                            float f = (float)vec3.f_82479_;
                            float f1 = (float)vec3.f_82480_;
                            float f2 = (float)vec3.f_82481_;
                            FogRenderer.m_109036_();
                            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                            RenderSystem.m_69458_((boolean)false);
                            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                            ShaderInstance shaderinstance = RenderSystem.m_157196_();
                            minecraft.f_91060_.f_109472_.m_166867_(p_181410_.m_85850_().m_85861_(), matrix4f, shaderinstance);
                            RenderSystem.m_69478_();
                            RenderSystem.m_69453_();
                            p_181410_.m_85836_();
                            p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                            p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(level.m_46942_(p_181412_) * 360.0f));
                            p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
                            starBuffer = StarHelper.createStars(starBuffer, 0.075f, 6000, 13000, false);
                            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
                            FogRenderer.m_109017_();
                            starBuffer.m_166867_(p_181410_.m_85850_().m_85861_(), starMatrix4f, GameRenderer.m_172808_());
                            p_181410_.m_85849_();
                            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                            p_181410_.m_85836_();
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.m_69493_();
                            RenderSystem.m_157427_(GameRenderer::m_172817_);
                            p_181410_.m_85836_();
                            p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                            p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(p_181412_) * 360.0f));
                            Matrix4f matrix4f1 = p_181410_.m_85850_().m_85861_();
                            p_181410_.m_85849_();
                            float f12 = 30.0f;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_TEXTURE);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                            bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85721_();
                            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                            p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                            p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(0.0f));
                            matrix4f1 = p_181410_.m_85850_().m_85861_();
                            RenderSystem.m_69461_();
                            float var20 = -3000.0f + (float)Minecraft.m_91087_().f_91074_.m_20186_() * 6.0f;
                            float scale = 100.0f * (0.2f - var20 / 10000.0f);
                            scale = Math.max(scale, 4.0f);
                            RenderSystem.m_157456_((int)0, (ResourceLocation)MARS_TEXTURE);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                            bufferbuilder.m_85982_(matrix4f1, -scale, -100.0f, scale).m_7421_(0.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, scale, -100.0f, scale).m_7421_(1.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, scale, -100.0f, -scale).m_7421_(1.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, -scale, -100.0f, -scale).m_7421_(0.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85721_();
                            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                            RenderSystem.m_69478_();
                            RenderSystem.m_69472_();
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.m_69461_();
                            p_181410_.m_85849_();
                            RenderSystem.m_69472_();
                            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            if (level.m_104583_().m_108882_()) {
                                RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
                            } else {
                                RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                            }
                            RenderSystem.m_69493_();
                            RenderSystem.m_69458_((boolean)true);
                        }
                    }
                };
            }
        });
    }

    static {
        MARS_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/mars.png");
        SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/no_a_sun.png");
    }
}

