/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ChestWearItemLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public ChestWearItemLayer(RenderLayerParent<T, M> entityRenderer) {
        super(entityRenderer);
    }

    public ModelPart getChestRenderer() {
        return ((HumanoidModel)this.m_117386_()).f_102810_;
    }

    public abstract boolean shouldRender(ItemStack var1, T var2);

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (!this.shouldRender(stack, livingEntity)) {
            return;
        }
        poseStack.m_85836_();
        if (livingEntity.m_6162_() && !(livingEntity instanceof Villager)) {
            poseStack.m_85837_(0.0, 0.03125, 0.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            poseStack.m_85837_(0.0, 1.0, 0.0);
        }
        this.getChestRenderer().m_104299_(poseStack);
        poseStack.m_85837_(0.0, -0.25, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85841_(0.625f, -0.625f, -0.625f);
        if (livingEntity instanceof Villager || livingEntity instanceof ZombieVillager) {
            poseStack.m_85837_(0.0, 0.1875, 0.0);
        }
        Minecraft.m_91087_().m_91292_().m_109322_(livingEntity, stack, ItemTransforms.TransformType.HEAD, false, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }
}

