/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controllers;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.network.GrappleEndMessage;
import com.yyon.grapplinghook.network.PlayerMovementMessage;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class GrappleController {
    public int entityId;
    public Level world;
    public Entity entity;
    public HashSet<GrapplehookEntity> grapplehookEntities = new HashSet();
    public HashSet<Integer> grapplehookEntityIds = new HashSet();
    public boolean attached = true;
    public Vec motion;
    public double playerForward = 0.0;
    public double playerStrafe = 0.0;
    public boolean playerJump = false;
    public boolean playerSneak = false;
    public Vec playerMovementUnrotated = new Vec(0.0, 0.0, 0.0);
    public Vec playerMovement = new Vec(0.0, 0.0, 0.0);
    public int onGroundTimer = 0;
    public int maxOnGroundTimer = 3;
    public double maxLen;
    public double playerMovementMult = 0.0;
    public int controllerId;
    public GrappleCustomization custom = null;
    boolean prevOnGround = false;
    public double repelMaxPush = 0.3;
    public boolean rocket_key = false;
    public double rocket_on = 0.0;
    boolean isOnWall = false;
    Vec wallDirection = null;
    BlockHitResult wallrunRaytraceResult = null;
    int ticksSinceLastWallrunSoundEffect = 0;

    public GrappleController(int grapplehookEntityId, int entityId, Level world, Vec pos, int controllerid, GrappleCustomization custom) {
        this.entityId = entityId;
        this.world = world;
        this.custom = custom;
        if (this.custom != null) {
            this.playerMovementMult = this.custom.playermovementmult;
            this.maxLen = custom.maxlen;
        }
        this.controllerId = controllerid;
        this.entity = world.m_6815_(entityId);
        this.motion = Vec.motionVec(this.entity);
        Vec newmotion = new Vec(this.entity.m_20182_().f_82479_ - this.entity.f_19790_, this.entity.m_20182_().f_82480_ - this.entity.f_19791_, this.entity.m_20182_().f_82481_ - this.entity.f_19792_);
        if (newmotion.x / this.motion.x < 2.0 && this.motion.x / newmotion.x < 2.0 && newmotion.y / this.motion.y < 2.0 && this.motion.y / newmotion.y < 2.0 && newmotion.z / this.motion.z < 2.0 && this.motion.z / newmotion.z < 2.0) {
            this.motion = newmotion;
        }
        this.onGroundTimer = 0;
        if (grapplehookEntityId != -1) {
            Entity grapplehookEntity = world.m_6815_(grapplehookEntityId);
            if (grapplehookEntity != null && grapplehookEntity.m_6084_() && grapplehookEntity instanceof GrapplehookEntity) {
                this.addHookEntity((GrapplehookEntity)grapplehookEntity);
            } else {
                grapplemod.LOGGER.warn("no hook entity");
                this.unattach();
            }
        }
        if (custom != null && custom.rocket) {
            ClientProxyInterface.proxy.updateRocketRegen(custom.rocket_active_time, custom.rocket_refuel_ratio);
        }
    }

    public void unattach() {
        if (ClientProxyInterface.proxy.unregisterController(this.entityId) != null) {
            this.attached = false;
            if (this.controllerId != GrapplemodUtils.AIRID) {
                CommonSetup.network.sendToServer((Object)new GrappleEndMessage(this.entityId, this.grapplehookEntityIds));
                ClientProxyInterface.proxy.createControl(GrapplemodUtils.AIRID, -1, this.entityId, this.entity.f_19853_, new Vec(0.0, 0.0, 0.0), null, this.custom);
            }
        }
    }

    public void doClientTick() {
        if (this.attached) {
            if (this.entity == null || !this.entity.m_6084_()) {
                this.unattach();
            } else {
                this.updatePlayerPos();
            }
        }
    }

    public void receivePlayerMovementMessage(float strafe, float forward, boolean jump, boolean sneak) {
        this.playerForward = forward;
        this.playerStrafe = strafe;
        this.playerSneak = sneak;
        this.playerMovementUnrotated = new Vec(strafe, 0.0, forward);
        this.playerMovement = this.playerMovementUnrotated.rotateYaw((float)((double)this.entity.m_146908_() * (Math.PI / 180)));
    }

    public void updatePlayerPos() {
        Entity entity = this.entity;
        if (this.attached && entity != null) {
            if (entity.m_20202_() != null) {
                this.unattach();
                this.updateServerPos();
                return;
            }
            this.normalGround(false);
            this.normalCollisions(false);
            this.applyAirFriction();
            Vec playerpos = Vec.positionVec(entity);
            playerpos = playerpos.add(new Vec(0.0, entity.m_20192_(), 0.0));
            Object additionalmotion = new Vec(0.0, 0.0, 0.0);
            Vec gravity = new Vec(0.0, -0.05, 0.0);
            this.motion.add_ip(gravity);
            boolean doJump = false;
            double jumpSpeed = 0.0;
            boolean isClimbing = false;
            boolean motor = false;
            if (this.custom.motor) {
                if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_motoronoff) && this.custom.motorwhencrouching) {
                    motor = true;
                } else if (!ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_motoronoff) && this.custom.motorwhennotcrouching) {
                    motor = true;
                }
            }
            boolean close = false;
            Vec averagemotiontowards = new Vec(0.0, 0.0, 0.0);
            double min_spherevec_dist = 99999.0;
            for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                Vec hookPos = Vec.positionVec((Entity)hookEntity);
                if (this.custom.phaserope) {
                    hookEntity.segmentHandler.updatePos(hookPos, playerpos, hookEntity.r);
                } else {
                    hookEntity.segmentHandler.update(hookPos, playerpos, hookEntity.r, false);
                }
                Vec anchor = hookEntity.segmentHandler.getClosest(hookPos);
                double distToAnchor = hookEntity.segmentHandler.getDistToAnchor();
                double remaininglength = motor ? Math.max(this.custom.maxlen, hookEntity.r) - distToAnchor : hookEntity.r - distToAnchor;
                Vec oldspherevec = playerpos.sub(anchor);
                Vec spherevec = oldspherevec.changeLen(remaininglength);
                Iterator<GrapplehookEntity> spherechange = spherevec.sub(oldspherevec);
                if (spherevec.length() < min_spherevec_dist) {
                    min_spherevec_dist = spherevec.length();
                }
                averagemotiontowards.add_ip(spherevec.changeLen(-1.0));
                if (motor) {
                    hookEntity.r = distToAnchor + oldspherevec.length();
                }
                if (!(oldspherevec.length() < remaininglength)) {
                    if (oldspherevec.length() - remaininglength > GrappleConfig.getConf().grapplinghook.other.rope_snap_buffer) {
                        this.unattach();
                        this.updateServerPos();
                        return;
                    }
                    additionalmotion = spherechange;
                }
                double dist = oldspherevec.length();
                this.calcTaut(dist, hookEntity);
                if (entity instanceof Player) {
                    double timer;
                    Player player = (Player)entity;
                    boolean isjumping = ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_jumpanddetach);
                    isjumping = isjumping && !this.playerJump;
                    this.playerJump = ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_jumpanddetach);
                    if (isjumping && this.onGroundTimer <= 0 && (timer = ClientProxyInterface.proxy.getTimeSinceLastRopeJump(this.entity.f_19853_)) > GrappleConfig.getConf().grapplinghook.other.rope_jump_cooldown_s * 20.0) {
                        doJump = true;
                        jumpSpeed = this.getJumpPower((Entity)player, spherevec, hookEntity);
                    }
                    if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_slow)) {
                        Vec motiontorwards = spherevec.changeLen(-0.1);
                        motiontorwards = new Vec(motiontorwards.x, 0.0, motiontorwards.z);
                        if (this.motion.dot(motiontorwards) < 0.0) {
                            this.motion.add_ip(motiontorwards);
                        }
                        Vec newmotion = this.dampenMotion(this.motion, motiontorwards);
                        this.motion = new Vec(newmotion.x, this.motion.y, newmotion.z);
                    }
                    if ((ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climb) || ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climbup) || ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climbdown)) && !motor) {
                        isClimbing = true;
                        if (anchor.y > playerpos.y) {
                            double climbup = 0.0;
                            if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climb)) {
                                climbup = this.playerForward;
                                if (ClientProxyInterface.proxy.isMovingSlowly(this.entity)) {
                                    climbup /= 0.3;
                                }
                                if (climbup > 1.0) {
                                    climbup = 1.0;
                                } else if (climbup < -1.0) {
                                    climbup = -1.0;
                                }
                            } else if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climbup)) {
                                climbup = 1.0;
                            } else if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_climbdown)) {
                                climbup = -1.0;
                            }
                            if (climbup != 0.0 && (dist + distToAnchor < this.maxLen || climbup > 0.0 || this.maxLen == 0.0)) {
                                hookEntity.r = dist + distToAnchor;
                                hookEntity.r -= climbup * GrappleConfig.getConf().grapplinghook.other.climb_speed;
                                if (hookEntity.r < distToAnchor) {
                                    hookEntity.r = dist + distToAnchor;
                                }
                                Vec additionalmovementdown = spherevec.changeLen(-climbup * GrappleConfig.getConf().grapplinghook.other.climb_speed).proj(new Vec(0.0, 1.0, 0.0));
                                if (additionalmovementdown.y < 0.0) {
                                    ((Vec)additionalmotion).add_ip(additionalmovementdown);
                                }
                            }
                        }
                    }
                }
                if (dist + distToAnchor < 2.0) {
                    close = true;
                }
                if (!(anchor.sub(playerpos.add(this.motion)).length() > remaininglength)) continue;
                this.motion = this.motion.removeAlong(spherevec);
            }
            averagemotiontowards.changeLen_ip(1.0);
            Vec facing = new Vec(entity.m_20154_()).normalize();
            if (motor) {
                double sidewayspull;
                Vec currentsideways;
                Vec sideways;
                Vec facingside;
                Vec facingxy;
                Vec anchor;
                Vec hookPos;
                boolean dopull = true;
                if (this.custom.doublehook && this.grapplehookEntities.size() == 1) {
                    boolean isdouble = true;
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        if (hookEntity.isDouble) continue;
                        isdouble = false;
                    }
                    if (isdouble && !this.custom.oneropepull) {
                        dopull = false;
                    }
                }
                Vec totalpull = new Vec(0.0, 0.0, 0.0);
                double accel = this.custom.motoracceleration / (double)this.grapplehookEntities.size();
                double minabssidewayspull = 999.0;
                boolean firstpull = true;
                boolean pullispositive = true;
                boolean pullissameway = true;
                for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                    hookPos = Vec.positionVec((Entity)hookEntity);
                    anchor = hookEntity.segmentHandler.getClosest(hookPos);
                    Vec spherevec = playerpos.sub(anchor);
                    Vec pull = spherevec.mult(-1.0);
                    hookEntity.pull = accel;
                    totalpull.add_ip(pull.changeLen(accel));
                    pull.changeLen_ip(hookEntity.pull);
                    if (!(pull.dot(facing) > 0.0) && !this.custom.pullbackwards || !this.custom.smartdoublemotor || this.grapplehookEntities.size() <= 1) continue;
                    facingxy = new Vec(facing.x, 0.0, facing.z);
                    facingside = facingxy.cross(new Vec(0.0, 1.0, 0.0)).normalize();
                    sideways = pull.proj(facingside);
                    currentsideways = this.motion.proj(facingside);
                    sideways.add_ip(currentsideways);
                    sidewayspull = sideways.dot(facingside);
                    if (Math.abs(sidewayspull) < minabssidewayspull) {
                        minabssidewayspull = Math.abs(sidewayspull);
                    }
                    if (firstpull) {
                        firstpull = false;
                        pullispositive = sidewayspull >= 0.0;
                        continue;
                    }
                    if (pullispositive == sidewayspull >= 0.0) continue;
                    pullissameway = false;
                }
                if (this.custom.smartdoublemotor && this.grapplehookEntities.size() > 1) {
                    totalpull = new Vec(0.0, 0.0, 0.0);
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        hookPos = Vec.positionVec((Entity)hookEntity);
                        anchor = hookEntity.segmentHandler.getClosest(hookPos);
                        Vec spherevec = playerpos.sub(anchor);
                        Vec pull = spherevec.mult(-1.0);
                        pull.changeLen_ip(hookEntity.pull);
                        if (pull.dot(facing) > 0.0 || this.custom.pullbackwards) {
                            facingxy = new Vec(facing.x, 0.0, facing.z);
                            facingside = facingxy.cross(new Vec(0.0, 1.0, 0.0)).normalize();
                            sideways = pull.proj(facingside);
                            currentsideways = this.motion.proj(facingside);
                            sideways.add_ip(currentsideways);
                            sidewayspull = sideways.dot(facingside);
                            if (pullissameway) {
                                if (Math.abs(sidewayspull) > minabssidewayspull + 0.05) {
                                    hookEntity.pull = 0.0;
                                }
                            } else {
                                hookEntity.pull = hookEntity.pull * minabssidewayspull / Math.abs(sidewayspull);
                            }
                            totalpull.add_ip(pull.changeLen(hookEntity.pull));
                            continue;
                        }
                        if (!hookEntity.isDouble || this.custom.oneropepull) continue;
                        dopull = false;
                    }
                }
                double pullmult = 1.0;
                if (this.custom.smartmotor && totalpull.y > 0.0 && this.onGroundTimer <= 0 && !entity.m_20096_()) {
                    double pulll;
                    Vec pullxzvector = new Vec(totalpull.x, 0.0, totalpull.z);
                    double pullxz = pullxzvector.length();
                    double motionxz = this.motion.proj(pullxzvector).dot(pullxzvector.normalize());
                    double facingxz = facing.proj(pullxzvector).dot(pullxzvector.normalize());
                    pullmult = (facingxz * (this.motion.y + gravity.y) - motionxz * facing.y) / (facing.y * pullxz - facingxz * totalpull.y);
                    if (facing.y * pullxz - facingxz * totalpull.y == 0.0) {
                        pullmult = 9999.0;
                    }
                    if ((pulll = pullmult * totalpull.length()) > this.custom.motoracceleration) {
                        pulll = this.custom.motoracceleration;
                    }
                    if (pulll < 0.0) {
                        pulll = 0.0;
                    }
                    pullmult = pulll / totalpull.length();
                }
                if (this.motion.dot(totalpull) > 0.0 && this.motion.proj(totalpull).length() + totalpull.mult(pullmult).length() > this.custom.motormaxspeed && (pullmult = (this.custom.motormaxspeed - this.motion.proj(totalpull).length()) / totalpull.length()) < 0.0) {
                    pullmult = 0.0;
                }
                if (this.custom.motordampener && totalpull.length() != 0.0) {
                    this.motion = this.dampenMotion(this.motion, totalpull);
                }
                if (dopull) {
                    for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
                        Vec hookPos2 = Vec.positionVec((Entity)hookEntity);
                        Vec anchor2 = hookEntity.segmentHandler.getClosest(hookPos2);
                        Vec spherevec = playerpos.sub(anchor2);
                        Vec pull = spherevec.mult(-1.0);
                        pull.changeLen_ip(hookEntity.pull * pullmult);
                        if (!(pull.dot(facing) > 0.0) && !this.custom.pullbackwards || !(hookEntity.pull > 0.0)) continue;
                        this.motion.add_ip(pull);
                    }
                }
                if (close && this.grapplehookEntities.size() <= 1 && (entity.f_19862_ || entity.f_19863_ || entity.m_20096_())) {
                    this.motion.mult_ip(0.6);
                }
            }
            if (this.custom.repel) {
                Vec blockpush = this.checkRepel(playerpos, entity.f_19853_);
                blockpush.mult_ip(this.custom.repelforce * 0.5);
                blockpush = new Vec(blockpush.x * 0.5, blockpush.y * 2.0, blockpush.z * 0.5);
                this.motion.add_ip(blockpush);
            }
            if (this.custom.rocket) {
                this.motion.add_ip(this.rocket(entity));
            }
            if (!doJump && !isClimbing) {
                this.applyPlayerMovement();
            }
            if (doJump) {
                if (jumpSpeed <= 0.0) {
                    jumpSpeed = 0.0;
                }
                if (jumpSpeed > GrappleConfig.getConf().grapplinghook.other.rope_jump_power) {
                    jumpSpeed = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
                }
                this.doJump(entity, jumpSpeed, averagemotiontowards, min_spherevec_dist);
                ClientProxyInterface.proxy.resetRopeJumpTime(this.entity.f_19853_);
                return;
            }
            Vec newmotion = this.motion.add((Vec)additionalmotion);
            if (Double.isNaN(newmotion.x) || Double.isNaN(newmotion.y) || Double.isNaN(newmotion.z)) {
                newmotion = new Vec(0.0, 0.0, 0.0);
                this.motion = new Vec(0.0, 0.0, 0.0);
                System.out.println("error: motion is NaN");
            }
            entity.m_20334_(newmotion.x, newmotion.y, newmotion.z);
            this.updateServerPos();
        }
    }

    public void calcTaut(double dist, GrapplehookEntity hookEntity) {
        if (hookEntity != null) {
            if (dist < hookEntity.r) {
                double taut = 1.0 - (hookEntity.r - dist) / 5.0;
                if (taut < 0.0) {
                    taut = 0.0;
                }
                hookEntity.taut = taut;
            } else {
                hookEntity.taut = 1.0;
            }
        }
    }

    public void normalCollisions(boolean sliding) {
        if (this.entity.f_19862_) {
            if (this.entity.m_20184_().f_82479_ == 0.0 && (!sliding || this.tryStepUp(new Vec(this.motion.x, 0.0, 0.0)))) {
                this.motion.x = 0.0;
            }
            if (this.entity.m_20184_().f_82481_ == 0.0 && (!sliding || this.tryStepUp(new Vec(0.0, 0.0, this.motion.z)))) {
                this.motion.z = 0.0;
            }
        }
        if (sliding && !this.entity.f_19862_) {
            if (this.entity.m_20182_().f_82479_ - this.entity.f_19790_ == 0.0) {
                this.motion.x = 0.0;
            }
            if (this.entity.m_20182_().f_82481_ - this.entity.f_19792_ == 0.0) {
                this.motion.z = 0.0;
            }
        }
        if (this.entity.f_19863_) {
            if (this.entity.m_20096_()) {
                if (!sliding && Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                    this.motion.y = this.entity.m_20184_().f_82480_;
                } else if (this.motion.y < 0.0) {
                    this.motion.y = 0.0;
                }
            } else if (this.motion.y > 0.0 && this.entity.f_19791_ == this.entity.m_20182_().f_82480_) {
                this.motion.y = 0.0;
            }
        }
    }

    public boolean tryStepUp(Vec collisionmotion) {
        if (collisionmotion.length() == 0.0) {
            return false;
        }
        Vec moveoffset = collisionmotion.changeLen(0.05).add(0.0, (double)this.entity.f_19793_ + 0.01, 0.0);
        Iterable collisions = this.entity.f_19853_.m_186431_(this.entity, this.entity.m_142469_().m_82386_(moveoffset.x, moveoffset.y, moveoffset.z));
        if (!collisions.iterator().hasNext()) {
            if (!this.entity.m_20096_()) {
                Vec pos = Vec.positionVec(this.entity);
                pos.add_ip(moveoffset);
                pos.setPos(this.entity);
                this.entity.f_19790_ = pos.x;
                this.entity.f_19791_ = pos.y;
                this.entity.f_19792_ = pos.z;
            }
            this.entity.f_19862_ = false;
            return false;
        }
        return true;
    }

    public void normalGround(boolean sliding) {
        if (this.entity.m_20096_()) {
            this.onGroundTimer = this.maxOnGroundTimer;
        } else if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if ((this.entity.m_20096_() || this.onGroundTimer > 0) && !sliding) {
            this.motion = Vec.motionVec(this.entity);
            if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.McKeys.keyBindJump)) {
                this.motion.y += 0.05;
            }
        }
        this.prevOnGround = this.entity.m_20096_();
    }

    private double getJumpPower(Entity player, double jumppower) {
        double maxjump = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
        if (this.onGroundTimer > 0) {
            this.onGroundTimer = 20;
            return 0.0;
        }
        if (player.m_20096_()) {
            jumppower = 0.0;
        }
        if (player.f_19862_ || player.f_19863_) {
            jumppower = maxjump;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        return jumppower;
    }

    public void doJump(Entity player, double jumppower, Vec averagemotiontowards, double min_spherevec_dist) {
        if (jumppower > 0.0) {
            if (GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle && min_spherevec_dist > 1.0) {
                this.motion.add_ip(averagemotiontowards.changeLen(jumppower));
            } else {
                this.motion.y = jumppower > player.m_20184_().f_82480_ + jumppower ? jumppower : (this.motion.y += jumppower);
            }
            this.motion.setMotion(player);
        }
        this.unattach();
        this.updateServerPos();
    }

    public double getJumpPower(Entity player, Vec spherevec, GrapplehookEntity hookEntity) {
        double current_speed;
        double maxjump = GrappleConfig.getConf().grapplinghook.other.rope_jump_power;
        Vec jump = new Vec(0.0, maxjump, 0.0);
        if (spherevec != null && !GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle) {
            jump = jump.proj(spherevec);
        }
        double jumppower = jump.y;
        if (spherevec != null && spherevec.y > 0.0) {
            jumppower = 0.0;
        }
        if (hookEntity != null && hookEntity.r < 1.0 && player.m_20182_().f_82480_ < hookEntity.m_20182_().f_82480_) {
            jumppower = maxjump;
        }
        jumppower = this.getJumpPower(player, jumppower);
        double d = current_speed = GrappleConfig.getConf().grapplinghook.other.rope_jump_at_angle ? -this.motion.distAlong(spherevec) : this.motion.y;
        if (current_speed > 0.0) {
            jumppower -= current_speed;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        return jumppower;
    }

    public Vec dampenMotion(Vec motion, Vec forward) {
        Vec newmotion = motion.proj(forward);
        double dampening = 0.05;
        return newmotion.mult(dampening).add(motion.mult(1.0 - dampening));
    }

    public void updateServerPos() {
        CommonSetup.network.sendToServer((Object)new PlayerMovementMessage(this.entityId, this.entity.m_20182_().f_82479_, this.entity.m_20182_().f_82480_, this.entity.m_20182_().f_82481_, this.entity.m_20184_().f_82479_, this.entity.m_20184_().f_82480_, this.entity.m_20184_().f_82481_));
    }

    public void receiveGrappleDetach() {
        this.unattach();
    }

    public void receiveEnderLaunch(double x, double y, double z) {
        this.motion.add_ip(x, y, z);
        this.motion.setMotion(this.entity);
    }

    public void applyAirFriction() {
        double dragforce = 0.005f;
        if (this.entity.m_20069_() || this.entity.m_20077_()) {
            dragforce = 0.25;
        }
        double vel = this.motion.length();
        dragforce = vel * dragforce;
        Vec airfric = new Vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changeLen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void applyPlayerMovement() {
        this.motion.add_ip(this.playerMovement.changeLen(0.015 + this.motion.length() * 0.01).mult(this.playerMovementMult));
    }

    public void addHookEntity(GrapplehookEntity hookEntity) {
        this.grapplehookEntities.add(hookEntity);
        hookEntity.r = hookEntity.segmentHandler.getDist(Vec.positionVec((Entity)hookEntity), Vec.positionVec(this.entity).add(new Vec(0.0, this.entity.m_20192_(), 0.0)));
        this.grapplehookEntityIds.add(hookEntity.m_142049_());
    }

    public Vec checkRepel(Vec p, Level w) {
        p = p.add(0.0, 0.75, 0.0);
        Vec v = new Vec(0.0, 0.0, 0.0);
        double t = (1.0 + Math.sqrt(5.0)) / 2.0;
        BlockPos pos = new BlockPos(Math.floor(p.x), Math.floor(p.y), Math.floor(p.z));
        if (this.hasBlock(pos, w)) {
            v.add_ip(0.0, 1.0, 0.0);
        } else {
            v.add_ip(this.vecDist(p, new Vec(-1.0, t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(1.0, t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(-1.0, -t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(1.0, -t, 0.0), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, -1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, -1.0, -t), w));
            v.add_ip(this.vecDist(p, new Vec(0.0, 1.0, -t), w));
            v.add_ip(this.vecDist(p, new Vec(t, 0.0, -1.0), w));
            v.add_ip(this.vecDist(p, new Vec(t, 0.0, 1.0), w));
            v.add_ip(this.vecDist(p, new Vec(-t, 0.0, -1.0), w));
            v.add_ip(this.vecDist(p, new Vec(-t, 0.0, 1.0), w));
        }
        if (v.length() > this.repelMaxPush) {
            v.changeLen_ip(this.repelMaxPush);
        }
        return v;
    }

    public Vec vecDist(Vec p, Vec v, Level w) {
        for (double i = 0.5; i < 10.0; i += 0.5) {
            Vec v2 = v.changeLen(i);
            BlockPos pos = new BlockPos(Math.floor(p.x + v2.x), Math.floor(p.y + v2.y), Math.floor(p.z + v2.z));
            if (!this.hasBlock(pos, w)) continue;
            Vec v3 = new Vec((double)pos.m_123341_() + 0.5 - p.x, (double)pos.m_123342_() + 0.5 - p.y, (double)pos.m_123343_() + 0.5 - p.z);
            v3.changeLen_ip(-1.0 / Math.pow(v3.length(), 2.0));
            return v3;
        }
        return new Vec(0.0, 0.0, 0.0);
    }

    public boolean hasBlock(BlockPos pos, Level w) {
        BlockState blockstate = w.m_8055_(pos);
        return !blockstate.m_60795_();
    }

    public void receiveGrappleDetachHook(int hookid) {
        if (this.grapplehookEntityIds.contains(hookid)) {
            this.grapplehookEntityIds.remove(hookid);
        } else {
            System.out.println("Error: controller received hook detach, but hook id not in grapplehookEntityIds");
        }
        GrapplehookEntity hookToRemove = null;
        for (GrapplehookEntity hookEntity : this.grapplehookEntities) {
            if (hookEntity.m_142049_() != hookid) continue;
            hookToRemove = hookEntity;
            break;
        }
        if (hookToRemove != null) {
            this.grapplehookEntities.remove((Object)hookToRemove);
        } else {
            System.out.println("Error: controller received hook detach, but hook entity not in grapplehookEntities");
        }
    }

    public Vec rocket(Entity entity) {
        if (ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_rocket)) {
            this.rocket_on = ClientProxyInterface.proxy.getRocketFunctioning();
            double rocket_force = this.custom.rocket_force * 0.225 * this.rocket_on;
            double yaw = entity.m_146908_();
            double pitch = -entity.m_146909_();
            Vec force = new Vec(0.0, 0.0, rocket_force);
            force = force.rotatePitch(Math.toRadians(pitch += this.custom.rocket_vertical_angle));
            force = force.rotateYaw(Math.toRadians(yaw));
            this.rocket_key = true;
            return force;
        }
        this.rocket_key = false;
        this.rocket_on = 0.0;
        return new Vec(0.0, 0.0, 0.0);
    }

    public Vec getNearbyWall(Vec tryfirst, Vec trysecond, double extra) {
        float entitywidth = this.entity.m_20205_();
        for (Vec direction : new Vec[]{tryfirst, trysecond, tryfirst.mult(-1.0), trysecond.mult(-1.0)}) {
            BlockHitResult raytraceresult = GrapplemodUtils.rayTraceBlocks(this.entity.f_19853_, Vec.positionVec(this.entity), Vec.positionVec(this.entity).add(direction.changeLen((double)(entitywidth / 2.0f) + extra)));
            if (raytraceresult == null) continue;
            this.wallrunRaytraceResult = raytraceresult;
            return direction;
        }
        return null;
    }

    public Vec getWallDirection() {
        Vec tryfirst = new Vec(0.0, 0.0, 0.0);
        Vec trysecond = new Vec(0.0, 0.0, 0.0);
        if (Math.abs(this.motion.x) > Math.abs(this.motion.z)) {
            tryfirst.x = this.motion.x > 0.0 ? 1.0 : -1.0;
            trysecond.z = this.motion.z > 0.0 ? 1.0 : -1.0;
        } else {
            tryfirst.z = this.motion.z > 0.0 ? 1.0 : -1.0;
            trysecond.x = this.motion.x > 0.0 ? 1.0 : -1.0;
        }
        return this.getNearbyWall(tryfirst, trysecond, 0.05);
    }

    public Vec getCorner(int cornernum, Vec facing, Vec sideways) {
        Vec corner = new Vec(0.0, 0.0, 0.0);
        if (cornernum / 2 == 0) {
            corner.add_ip(facing);
        } else {
            corner.add_ip(facing.mult(-1.0));
        }
        if (cornernum % 2 == 0) {
            corner.add_ip(sideways);
        } else {
            corner.add_ip(sideways.mult(-1.0));
        }
        return corner;
    }

    public boolean wallNearby(double dist) {
        float entitywidth = this.entity.m_20205_();
        Vec v1 = new Vec((double)(entitywidth / 2.0f) + dist, 0.0, 0.0);
        Vec v2 = new Vec(0.0, 0.0, (double)(entitywidth / 2.0f) + dist);
        for (int i = 0; i < 4; ++i) {
            Vec corner1 = this.getCorner(i, v1, v2);
            Vec corner2 = this.getCorner((i + 1) % 4, v1, v2);
            BlockHitResult raytraceresult = GrapplemodUtils.rayTraceBlocks(this.entity.f_19853_, Vec.positionVec(this.entity).add(corner1), Vec.positionVec(this.entity).add(corner2));
            if (raytraceresult == null) continue;
            return true;
        }
        return false;
    }

    public boolean isWallRunning() {
        double current_speed = Math.sqrt(Math.pow(this.motion.x, 2.0) + Math.pow(this.motion.z, 2.0));
        if (current_speed < GrappleConfig.getConf().enchantments.wallrun.wallrun_min_speed) {
            this.isOnWall = false;
            return false;
        }
        if (this.isOnWall) {
            ClientProxyInterface.proxy.setWallrunTicks(ClientProxyInterface.proxy.getWallrunTicks() + 1);
        }
        if ((double)ClientProxyInterface.proxy.getWallrunTicks() < GrappleConfig.getConf().enchantments.wallrun.max_wallrun_time * 40.0) {
            if (!this.playerSneak) {
                if (this.isOnWall && !this.entity.m_20096_() && this.entity.f_19862_) {
                    return !(this.entity instanceof LivingEntity) || !((LivingEntity)this.entity).m_6147_();
                }
                if (ClientProxyInterface.proxy.isWallRunning(this.entity, this.motion)) {
                    this.isOnWall = true;
                    return true;
                }
            }
            this.isOnWall = false;
        }
        if (ClientProxyInterface.proxy.getWallrunTicks() > 0 && (this.entity.m_20096_() || !this.entity.f_19862_ && !this.wallNearby(0.2))) {
            this.ticksSinceLastWallrunSoundEffect = 0;
        }
        return false;
    }

    public boolean applyWallrun() {
        boolean wallrun = this.isWallRunning();
        if (this.playerJump) {
            if (wallrun) {
                return false;
            }
            this.playerJump = false;
        }
        if (wallrun && !ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_jumpanddetach)) {
            double vel;
            double dragforce;
            Vec wallside = this.getWallDirection();
            if (wallside != null) {
                this.wallDirection = wallside;
            }
            if (this.wallDirection == null) {
                return false;
            }
            if (!this.playerJump) {
                this.motion.y = 0.0;
            }
            if ((dragforce = GrappleConfig.getConf().enchantments.wallrun.wallrun_drag) > (vel = this.motion.length())) {
                dragforce = vel;
            }
            Vec wallfric = new Vec(this.motion);
            if (wallside != null) {
                wallfric.removeAlong(wallside);
            }
            wallfric.changeLen_ip(-dragforce);
            this.motion.add_ip(wallfric);
            ++this.ticksSinceLastWallrunSoundEffect;
            if ((double)this.ticksSinceLastWallrunSoundEffect > GrappleConfig.getClientConf().sounds.wallrun_sound_effect_time_s * 20.0 * GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed / (vel + 1.0E-8) && this.wallrunRaytraceResult != null) {
                BlockPos blockpos = this.wallrunRaytraceResult.m_82425_();
                BlockState blockState = this.entity.f_19853_.m_8055_(blockpos);
                Block blockIn = blockState.m_60734_();
                SoundType soundtype = blockIn.getSoundType(blockState, (LevelReader)this.world, blockpos, this.entity);
                this.entity.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.3f * GrappleConfig.getClientConf().sounds.wallrun_sound_volume, soundtype.m_56774_());
                this.ticksSinceLastWallrunSoundEffect = 0;
            }
        }
        boolean isjumping = ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_jumpanddetach) && this.isOnWall;
        isjumping = isjumping && !this.playerJump;
        boolean bl = this.playerJump = ClientProxyInterface.proxy.isKeyDown(ClientProxyInterface.GrappleKeys.key_jumpanddetach) && this.isOnWall;
        if (isjumping && wallrun) {
            ClientProxyInterface.proxy.setWallrunTicks(0);
            Vec jump = new Vec(0.0, GrappleConfig.getConf().enchantments.wallrun.wall_jump_up, 0.0);
            if (this.wallDirection != null) {
                jump.add_ip(this.wallDirection.mult(-GrappleConfig.getConf().enchantments.wallrun.wall_jump_side));
            }
            this.motion.add_ip(jump);
            wallrun = false;
            ClientProxyInterface.proxy.playWallrunJumpSound(this.entity);
        }
        return wallrun;
    }

    public Vec wallrunPressAgainstWall() {
        if (this.wallDirection != null) {
            return this.wallDirection.changeLen(0.05);
        }
        return new Vec(0.0, 0.0, 0.0);
    }

    public void doubleJump() {
        if (-this.motion.y > GrappleConfig.getConf().enchantments.doublejump.dont_doublejump_if_falling_faster_than) {
            return;
        }
        if (this.motion.y < 0.0 && !GrappleConfig.getConf().enchantments.doublejump.doublejump_relative_to_falling) {
            this.motion.y = 0.0;
        }
        this.motion.y += GrappleConfig.getConf().enchantments.doublejump.doublejumpforce;
        this.motion.setMotion(this.entity);
    }

    public void applySlidingFriction() {
        double dragforce = GrappleConfig.getConf().enchantments.slide.sliding_friction;
        if (dragforce > this.motion.length()) {
            dragforce = this.motion.length();
        }
        Vec airfric = new Vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changeLen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void slidingJump() {
        this.motion.y = GrappleConfig.getConf().enchantments.slide.slidingjumpforce;
    }
}

