/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.UserInput;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class CombinedInputHandler
implements IUserInputHandler {
    private final List<IUserInputHandler> inputHandlers;
    private final Map<InputConstants.Key, IUserInputHandler> mousedDown = new HashMap<InputConstants.Key, IUserInputHandler>();
    @Nullable
    private IUserInputHandler dragStarted;

    public CombinedInputHandler(IUserInputHandler ... inputHandlers) {
        this.inputHandlers = List.of(inputHandlers);
    }

    public CombinedInputHandler(List<IUserInputHandler> inputHandlers) {
        this.inputHandlers = List.copyOf(inputHandlers);
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IKeyBindings keyBindings) {
        return switch (input.getClickState()) {
            default -> throw new IncompatibleClassChangeError();
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, input, keyBindings);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, input, keyBindings);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, input, keyBindings);
        };
    }

    private Optional<IUserInputHandler> handleImmediateClick(Screen screen, UserInput input, IKeyBindings keyBindings) {
        this.mousedDown.remove(input.getKey());
        return this.handleClickInternal(screen, input, keyBindings).map(handled -> this);
    }

    private Optional<IUserInputHandler> handleSimulateClick(Screen screen, UserInput input, IKeyBindings keyBindings) {
        this.mousedDown.remove(input.getKey());
        return this.handleClickInternal(screen, input, keyBindings).map(handled -> {
            this.mousedDown.put(input.getKey(), (IUserInputHandler)handled);
            return this;
        });
    }

    private Optional<IUserInputHandler> handleExecuteClick(Screen screen, UserInput input, IKeyBindings keyBindings) {
        return Optional.ofNullable(this.mousedDown.remove(input.getKey())).map(inputHandler -> inputHandler.handleUserInput(screen, input, keyBindings)).map(handled -> this);
    }

    private Optional<IUserInputHandler> handleClickInternal(Screen screen, UserInput input, IKeyBindings keyBindings) {
        Optional<IUserInputHandler> firstHandled = Optional.empty();
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            if (firstHandled.isEmpty()) {
                firstHandled = inputHandler.handleUserInput(screen, input, keyBindings);
                if (!firstHandled.isEmpty()) continue;
                inputHandler.handleMouseClickedOut(input.getKey());
                continue;
            }
            inputHandler.handleMouseClickedOut(input.getKey());
        }
        return firstHandled;
    }

    @Override
    public void handleMouseClickedOut(InputConstants.Key key) {
        this.mousedDown.remove(key);
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            inputHandler.handleMouseClickedOut(key);
        }
    }

    public void handleGuiChange() {
        Set<InputConstants.Key> keys = Set.copyOf(this.mousedDown.keySet());
        for (InputConstants.Key key : keys) {
            this.handleMouseClickedOut(key);
        }
        this.handleDragCanceled();
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.inputHandlers.stream().anyMatch(inputHandler -> inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta));
    }

    @Override
    public Optional<IUserInputHandler> handleDragStart(Screen screen, UserInput input) {
        if (this.dragStarted != null) {
            this.dragStarted.handleDragCanceled();
        }
        Optional dragStarted = this.inputHandlers.stream().map(i -> i.handleDragStart(screen, input)).flatMap(Optional::stream).findFirst();
        this.dragStarted = dragStarted.orElse(null);
        return dragStarted.map(started -> this);
    }

    @Override
    public Optional<IUserInputHandler> handleDragComplete(Screen screen, UserInput input) {
        if (this.dragStarted == null) {
            return Optional.empty();
        }
        this.dragStarted.handleDragComplete(screen, input);
        this.dragStarted = null;
        return Optional.of(this);
    }

    @Override
    public void handleDragCanceled() {
        if (this.dragStarted != null) {
            this.dragStarted.handleDragCanceled();
            this.dragStarted = null;
        }
    }
}

