/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;

public class FramedSlopePanelModel
extends FramedBlockModel {
    private static final float ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private final Direction facing;
    private final Rotation rotation;
    private final Direction orientation;
    private final boolean front;

    public FramedSlopePanelModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (Rotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
        this.front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation.m_122424_()) {
            Direction cutDir = this.front ? this.facing : this.facing.m_122424_();
            BakedQuad slabQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis && BakedQuadTransformer.createTopBottomQuad(slabQuad, cutDir, 0.5f) || !yAxis && BakedQuadTransformer.createVerticalSideQuad(slabQuad, cutDir, 0.5f)) {
                quadMap.get(face).add(slabQuad);
            }
        } else if (face == this.facing.m_122424_()) {
            BakedQuad slopeQuad = FramedSlopePanelModel.createSlope(quad, this.facing, this.orientation);
            if (!this.front) {
                BakedQuadTransformer.offsetQuadInDir(slopeQuad, this.facing, 0.5f);
            }
            quadMap.get(null).add(slopeQuad);
        } else if (face == this.facing) {
            if (this.front) {
                BakedQuad baseQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setQuadPosInFacingDir(baseQuad, 0.5f);
                quadMap.get(null).add(baseQuad);
            }
        } else if (face != this.orientation) {
            float depth = this.front ? 1.0f : 0.5f;
            float offset = this.front ? 0.5f : 0.0f;
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis) {
                if (BakedQuadTransformer.createVerticalSideTriangleQuad(triQuad, face == this.facing.m_122427_(), this.rotation == Rotation.DOWN, depth, offset)) {
                    if (this.front) {
                        BakedQuadTransformer.createVerticalSideQuad(triQuad, this.facing, 0.5f);
                    }
                    quadMap.get(face).add(triQuad);
                }
            } else if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.facing.m_122424_(), this.rotation == Rotation.RIGHT, depth, offset)) {
                if (this.front) {
                    BakedQuadTransformer.createTopBottomQuad(triQuad, this.facing, 0.5f);
                }
                quadMap.get(face).add(triQuad);
            }
        }
    }

    public static BakedQuad createSlope(BakedQuad quad, Direction facing, Direction orientation) {
        Preconditions.checkArgument((facing.m_122434_() != orientation.m_122434_() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        Vector3f origin = new Vector3f(facing == Direction.WEST || Utils.isZ(facing) && orientation == Direction.WEST ? 1.0f : 0.0f, orientation == Direction.DOWN ? 1.0f : 0.0f, facing == Direction.NORTH || Utils.isX(facing) && orientation == Direction.NORTH ? 1.0f : 0.0f);
        float angle = Utils.isPositive(orientation) == Utils.isY(orientation) == Utils.isX(facing) == Utils.isPositive(facing) ? -ANGLE : ANGLE;
        BakedQuad slope = ModelUtils.duplicateQuad(quad);
        BakedQuadTransformer.rotateQuadAroundAxis(slope, Utils.isY(orientation) ? facing.m_122427_().m_122434_() : Direction.Axis.Y, origin, angle, true);
        return slope;
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

