/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            Direction baseFace;
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
            Direction stairFace = right ? dir.m_122427_() : dir.m_122428_();
            Direction direction = baseFace = top ? Direction.UP : Direction.DOWN;
            if (type == BlockType.FRAMED_HALF_STAIRS) {
                return HalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, right, stairFace, adjState, side);
            }
            if (type == BlockType.FRAMED_VERTICAL_STAIRS) {
                return HalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, right, adjState, side);
            }
            if (side == stairFace) {
                return switch (type) {
                    case BlockType.FRAMED_STAIRS -> HalfStairsSkipPredicate.testAgainstStairs(level, pos, top, adjState, side);
                    case BlockType.FRAMED_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                    default -> false;
                };
            }
            return switch (type) {
                case BlockType.FRAMED_SLAB_EDGE -> HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, right, baseFace, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, dir, right, baseFace, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> HalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, dir, top, right, baseFace, adjState, side);
                case BlockType.FRAMED_PANEL -> HalfStairsSkipPredicate.testAgainstPanel(level, pos, dir, right, baseFace, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> HalfStairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, stairFace, baseFace, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, right, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction stairFace, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (side == stairFace) {
            return adjDir == dir && adjTop == top && adjRight != right && SideSkipPredicate.compareState(level, pos, side);
        }
        if (Utils.isY(side)) {
            return adjDir == dir && adjTop != top && adjRight == right && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir) {
            return adjDir == dir.m_122424_() && adjRight != right && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        return top == adjTop && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjTop == top && adjDir == dir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction stairFace;
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        Direction direction = stairFace = right ? dir.m_122427_() : dir.m_122428_();
        if (side == stairFace && adjType != StairsType.VERTICAL) {
            if (right && adjDir == dir || !right && adjDir == dir.m_122427_()) {
                return adjType.isTop() != top && SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (side == dir && adjType == StairsType.VERTICAL && (!right && adjDir == dir || right && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir.m_122428_()) {
            return adjTop == top == (side == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.m_122424_() && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir && (right && adjDir == dir.m_122424_() || !right && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == baseFace.m_122424_() && (right && adjDir == dir.m_122427_() || !right && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.m_122424_() && side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (right && adjDir == dir.m_122427_() || !right && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, Direction stairFace, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        return adjDir.m_122434_() != dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, stairFace, stairFace);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side != dir.m_122424_() || adjTop != top) {
            return false;
        }
        if (right && adjDir == dir.m_122424_() || !right && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side != adjRot.withFacing(adjDir) || adjRot.isVertical() && top != (adjRot == Rotation.UP)) {
            return false;
        }
        if (!right && (adjDir == dir.m_122428_() && !adjFront || adjDir == dir.m_122427_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (right && (adjDir == dir.m_122427_() && !adjFront || adjDir == dir.m_122428_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot.withFacing(adjDir) != side.m_122424_()) {
            return false;
        }
        if (adjRot.isVertical() && top == (adjRot == Rotation.DOWN) && (!right && adjDir == dir.m_122428_() || right && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (!adjRot.isVertical() && (!right && adjDir == dir.m_122428_() || right && adjDir == dir.m_122427_())) {
            return right == (adjRot == Rotation.RIGHT) && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side.m_122434_() != adjRot.withFacing(adjDir).m_122434_() || adjRot.isVertical() && top != (side == Direction.UP)) {
            return false;
        }
        if (!right && (adjDir == dir.m_122428_() && !adjFront || adjDir == dir.m_122427_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (right && (adjDir == dir.m_122427_() && !adjFront || adjDir == dir.m_122428_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side.m_122434_() != adjRot.withFacing(adjDir).m_122434_() || adjRot.isVertical() && top != (side == Direction.UP)) {
            return false;
        }
        if (adjRot.isVertical()) {
            boolean sameOrientation;
            boolean bl = sameOrientation = top == (adjRot == Rotation.UP);
            if (!right && (adjDir == dir.m_122428_() && !sameOrientation || adjDir == dir.m_122427_() && sameOrientation)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (right && (adjDir == dir.m_122427_() && !sameOrientation || adjDir == dir.m_122428_() && sameOrientation)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (right == (adjRot == Rotation.RIGHT) && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean right, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == dir || adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, side, right ? dir.m_122427_() : dir.m_122428_());
        }
        return false;
    }
}

