/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ServerConfig INSTANCE;
    public static boolean allowBlockEntities;
    public static boolean enableIntangibleFeature;
    public static Item intangibleMarkerItem;
    private final ForgeConfigSpec.BooleanValue allowBlockEntitiesValue;
    private final ForgeConfigSpec.BooleanValue enableIntangibleFeatureValue;
    private final ForgeConfigSpec.ConfigValue<String> intangibleMarkerItemValue;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.allowBlockEntitiesValue = builder.comment("Whether blocks with block entities can be placed in Framed Blocks").translation("config.framedblocks.allowBlockEntities").define("allowBlockEntities", false);
        this.enableIntangibleFeatureValue = builder.comment("Enables the intangbility feature. Disabling this also prevents moving through blocks that are already marked as intangible").translation("config.framedblocks.enableIntangibleFeature").define("enableIntangibleFeature", false);
        this.intangibleMarkerItemValue = builder.comment("The item to use for making Framed Blocks intangible. The value must be a valid item registry name").translation("config.framedblocks.intangibleMarkerItem").define("intangibleMarkerItem", (Object)Items.f_42714_.getRegistryName().toString(), ServerConfig::validateItemName);
        builder.pop();
    }

    private static boolean validateItemName(Object obj) {
        String name;
        ResourceLocation key;
        if (obj instanceof String && ForgeRegistries.ITEMS.containsKey(key = new ResourceLocation(name = (String)obj))) {
            return ForgeRegistries.ITEMS.getValue(key) != Items.f_41852_;
        }
        return false;
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER && event.getConfig().getModId().equals("framedblocks")) {
            allowBlockEntities = (Boolean)this.allowBlockEntitiesValue.get();
            enableIntangibleFeature = (Boolean)this.enableIntangibleFeatureValue.get();
            intangibleMarkerItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.intangibleMarkerItemValue.get()));
        }
    }

    static {
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ServerConfig)configSpecPair.getLeft();
    }
}

