/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface PotatoProjectileRenderMode {
    @OnlyIn(value=Dist.CLIENT)
    public void transform(PoseStack var1, PotatoProjectileEntity var2, float var3);

    public static int entityRandom(Entity entity, int maxValue) {
        return System.identityHashCode(entity) * 31 % maxValue;
    }

    public static class StuckToEntity
    implements PotatoProjectileRenderMode {
        private Vec3 offset;

        public StuckToEntity(Vec3 offset) {
            this.offset = offset;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.deg(Mth.m_14136_((double)this.offset.f_82479_, (double)this.offset.f_82481_)));
        }
    }

    public static class TowardMotion
    implements PotatoProjectileRenderMode {
        private int spriteAngleOffset;
        private float spin;

        public TowardMotion(int spriteAngleOffset, float spin) {
            this.spriteAngleOffset = spriteAngleOffset;
            this.spin = spin;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            Vec3 diff = entity.m_20184_();
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.deg(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_)))).rotateX((double)(270.0f + AngleHelper.deg(Mth.m_14136_((double)diff.f_82480_, (double)(-Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_))))))));
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(((float)entity.f_19797_ + pt) * 20.0f * this.spin + (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 360)))).rotateZ((double)(-this.spriteAngleOffset));
        }
    }

    public static class Tumble
    extends Billboard {
        public static final Tumble INSTANCE = new Tumble();

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            super.transform(ms, entity, pt);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateZ((double)(((float)entity.f_19797_ + pt) * 2.0f * (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 16)))).rotateX((double)(((float)entity.f_19797_ + pt) * (float)PotatoProjectileRenderMode.entityRandom((Entity)entity, 32)));
        }
    }

    public static class Billboard
    implements PotatoProjectileRenderMode {
        public static final Billboard INSTANCE = new Billboard();

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void transform(PoseStack ms, PotatoProjectileEntity entity, float pt) {
            Minecraft mc = Minecraft.m_91087_();
            Vec3 p1 = mc.m_91288_().m_20299_(pt);
            Vec3 diff = entity.m_142469_().m_82399_().m_82546_(p1);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(AngleHelper.deg(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_)) + 180.0f))).rotateX((double)AngleHelper.deg(Mth.m_14136_((double)diff.f_82480_, (double)Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_))))));
        }
    }
}

