/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.filtering;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SchematicInstances {
    public static WorldAttached<Cache<Integer, SchematicWorld>> loadedSchematics = new WorldAttached($ -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());

    public static void register() {
    }

    @Nullable
    public static SchematicWorld get(Level world, ItemStack schematic) {
        int hash;
        Cache<Integer, SchematicWorld> map = loadedSchematics.get((LevelAccessor)world);
        SchematicWorld ifPresent = (SchematicWorld)((Object)map.getIfPresent((Object)(hash = SchematicInstances.getHash(schematic))));
        if (ifPresent != null) {
            return ifPresent;
        }
        SchematicWorld loadWorld = SchematicInstances.loadWorld(world, schematic);
        if (loadWorld == null) {
            return null;
        }
        map.put((Object)hash, (Object)loadWorld);
        return loadWorld;
    }

    private static SchematicWorld loadWorld(Level wrapped, ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return null;
        }
        if (!schematic.m_41783_().m_128471_("Deployed")) {
            return null;
        }
        StructureTemplate activeTemplate = SchematicItem.loadSchematic(schematic);
        if (activeTemplate.m_163801_().equals((Object)Vec3i.f_123288_)) {
            return null;
        }
        BlockPos anchor = NbtUtils.m_129239_((CompoundTag)schematic.m_41783_().m_128469_("Anchor"));
        SchematicWorld world = new SchematicWorld(anchor, wrapped);
        StructurePlaceSettings settings = SchematicItem.getSettings(schematic);
        activeTemplate.m_74536_((ServerLevelAccessor)world, anchor, anchor, settings, wrapped.m_5822_(), 2);
        return world;
    }

    public static void clearHash(ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return;
        }
        schematic.m_41783_().m_128473_("SchematicHash");
    }

    public static int getHash(ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return -1;
        }
        CompoundTag tag = schematic.m_41783_();
        if (!tag.m_128441_("SchematicHash")) {
            tag.m_128405_("SchematicHash", tag.toString().hashCode());
        }
        return tag.m_128451_("SchematicHash");
    }
}

