/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.ControlsHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.TrainHUD;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandlerClient;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingPhysics;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.content.curiosities.armor.CopperBacktankArmorLayer;
import com.simibubi.create.content.curiosities.girder.GirderWrenchBehavior;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.curiosities.tools.BlueprintOverlayRenderer;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.logistics.block.depot.EjectorTargetHandler;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlockItem;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.content.logistics.trains.CameraDistanceModifier;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.CarriageCouplingRenderer;
import com.simibubi.create.content.logistics.trains.entity.TrainRelocator;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingClient;
import com.simibubi.create.content.logistics.trains.management.schedule.TrainHatArmorLayer;
import com.simibubi.create.content.logistics.trains.track.CurvedTrackInteraction;
import com.simibubi.create.content.logistics.trains.track.TrackBlockOutline;
import com.simibubi.create.content.logistics.trains.track.TrackPlacement;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.LeftClickPacket;
import com.simibubi.create.foundation.ponder.PonderTooltipHandler;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueHandler;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.CameraAngleAnimationService;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String ITEM_PREFIX = "item.create";
    private static final String BLOCK_PREFIX = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (event.phase == TickEvent.Phase.START) {
            LinkedControllerClientHandler.tick();
            ControlsHandler.tick();
            AirCurrent.tickClientPlayerSounds();
            return;
        }
        SoundScapes.tick();
        AnimationTickHolder.tick();
        ScrollValueHandler.tick();
        CreateClient.SCHEMATIC_SENDER.tick();
        CreateClient.SCHEMATIC_AND_QUILL_HANDLER.tick();
        CreateClient.GLUE_HANDLER.tick();
        CreateClient.SCHEMATIC_HANDLER.tick();
        CreateClient.ZAPPER_RENDER_HANDLER.tick();
        CreateClient.POTATO_CANNON_RENDER_HANDLER.tick();
        CreateClient.SOUL_PULSE_EFFECT_HANDLER.tick((Level)world);
        CreateClient.RAILWAYS.clientTick();
        ContraptionHandler.tick((Level)world);
        CapabilityMinecartController.tick((Level)world);
        CouplingPhysics.tick((Level)world);
        PonderTooltipHandler.tick();
        ServerSpeedProvider.clientTick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        GirderWrenchBehavior.tick();
        WorldshaperRenderHandler.tick();
        CouplingHandlerClient.tick();
        CouplingRenderer.tickDebugModeRenders();
        KineticDebugger.tick();
        ExtendoGripRenderHandler.tick();
        ArmInteractionPointHandler.tick();
        EjectorTargetHandler.tick();
        PlacementHelpers.tick();
        CreateClient.OUTLINER.tickOutlines();
        CreateClient.GHOST_BLOCKS.tickGhosts();
        ContraptionRenderDispatcher.tick((Level)world);
        BlueprintOverlayRenderer.tick();
        ToolboxHandlerClient.clientTick();
        TrackTargetingClient.clientTick();
        TrackPlacement.clientTick();
        TrainRelocator.clientTick();
        DisplayLinkBlockItem.clientTick();
        CurvedTrackInteraction.clientTick();
        CameraDistanceModifier.tick();
        CameraAngleAnimationService.tick();
        TrainHUD.tick();
    }

    @SubscribeEvent
    public static void onRenderSelection(DrawSelectionEvent event) {
    }

    @SubscribeEvent
    public static void onJoin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        CreateClient.checkGraphicsFanciness();
    }

    @SubscribeEvent
    public static void onLeave(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        CreateClient.RAILWAYS.cleanUp();
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (world.m_5776_() && world instanceof ClientLevel && !(world instanceof WrappedClientWorld)) {
            CreateClient.invalidateRenderers();
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        if (!event.getWorld().m_5776_()) {
            return;
        }
        CreateClient.invalidateRenderers();
        CreateClient.SOUL_PULSE_EFFECT_HANDLER.refresh();
        AnimationTickHolder.reset();
        ControlsHandler.levelUnloaded(event.getWorld());
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelLastEvent event) {
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float pt = AnimationTickHolder.getPartialTicks();
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        TrackBlockOutline.drawCurveSelection(ms, buffer);
        TrackTargetingClient.render(ms, buffer);
        CouplingRenderer.renderAll(ms, buffer);
        CarriageCouplingRenderer.renderAll(ms, buffer);
        CreateClient.SCHEMATIC_HANDLER.render(ms, buffer);
        CreateClient.GHOST_BLOCKS.renderAll(ms, buffer);
        CreateClient.OUTLINER.renderOutlines(ms, buffer, pt);
        buffer.draw();
        RenderSystem.m_69481_();
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        if (CameraAngleAnimationService.isYawAnimating()) {
            event.setYaw(CameraAngleAnimationService.getYaw(partialTicks));
        }
        if (CameraAngleAnimationService.isPitchAnimating()) {
            event.setPitch(CameraAngleAnimationService.getPitch(partialTicks));
        }
    }

    @SubscribeEvent
    public static void getItemTooltipColor(RenderTooltipEvent.Color event) {
        PonderTooltipHandler.handleTooltipColor(event);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        List<Component> kineticStats;
        BlockItem item;
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.m_41720_().m_5671_(stack);
        if ((translationKey.startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) && TooltipHelper.hasTooltip(stack, event.getPlayer())) {
            List itemTooltip = event.getToolTip();
            ArrayList<Component> toolTip = new ArrayList<Component>();
            toolTip.add((Component)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
        if (stack.m_41720_() instanceof BlockItem && ((item = (BlockItem)stack.m_41720_()).m_40614_() instanceof IRotate || item.m_40614_() instanceof SteamEngineBlock) && !(kineticStats = ItemDescription.getKineticStats(item.m_40614_())).isEmpty()) {
            event.getToolTip().add(new TextComponent(""));
            event.getToolTip().addAll(kineticStats);
        }
        PonderTooltipHandler.addToTooltip(event.getToolTip(), stack);
        SequencedAssemblyRecipe.addToTooltip(event.getToolTip(), stack);
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity;
        if (event.getEntityMounting() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (event.isDismounting()) {
            CameraDistanceModifier.reset();
            return;
        }
        if (!event.isMounting() || !((entity = event.getEntityBeingMounted()) instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity carriage = (CarriageContraptionEntity)entity;
        CameraDistanceModifier.zoomOut();
    }

    protected static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    @SubscribeEvent
    public static void getFogDensity(EntityViewRenderEvent.FogDensity event) {
        Camera info = event.getCamera();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidstate = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidstate.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidstate.m_76152_();
        if (((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6212_(fluid)) {
            event.setDensity(5.0f);
            event.setCanceled(true);
            return;
        }
        if (((ForgeFlowingFluid.Flowing)AllFluids.HONEY.get()).m_6212_(fluid)) {
            event.setDensity(1.5f);
            event.setCanceled(true);
            return;
        }
        if (FluidHelper.isWater(fluid) && ((CopperArmorItem)((Object)AllItems.DIVING_HELMET.get())).isWornBy(Minecraft.m_91087_().f_91075_)) {
            event.setDensity(300.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void getFogColor(EntityViewRenderEvent.FogColors event) {
        Camera info = event.getCamera();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidstate = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidstate.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidstate.m_76152_();
        if (((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6212_(fluid)) {
            event.setRed(0.3828125f);
            event.setGreen(0.125f);
            event.setBlue(0.125f);
        }
        if (((ForgeFlowingFluid.Flowing)AllFluids.HONEY.get()).m_6212_(fluid)) {
            event.setRed(0.9140625f);
            event.setGreen(0.6796875f);
            event.setBlue(0.18359375f);
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof ZapperItem) {
            AllPackets.channel.sendToServer((Object)new LeftClickPacket());
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)CreateClient.RESOURCE_RELOAD_LISTENER);
        }

        @SubscribeEvent
        public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            CopperBacktankArmorLayer.registerOnAll(dispatcher);
            TrainHatArmorLayer.registerOnAll(dispatcher);
        }

        @SubscribeEvent
        public static void loadCompleted(FMLLoadCompleteEvent event) {
            ModContainer createContainer = (ModContainer)ModList.get().getModContainerById("create").orElseThrow(() -> new IllegalStateException("Create Mod Container missing after loadCompleted"));
            createContainer.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, previousScreen) -> BaseConfigScreen.forCreate(previousScreen)));
        }
    }
}

