/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util.math.shapes;

import fuzs.diagonalfences.DiagonalFences;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public abstract class ExtensibleVoxelShape
extends SliceShape {
    private final Field partField = ObfuscationReflectionHelper.findField(VoxelShape.class, (String)"f_83211_");
    private final Method getValuesMethod = ObfuscationReflectionHelper.findMethod(VoxelShape.class, (String)"m_7700_", (Class[])new Class[]{Direction.Axis.class});

    public ExtensibleVoxelShape(VoxelShape voxelProvider) {
        super(voxelProvider, Direction.Axis.X, 0);
        this.setVoxelPart((VoxelShape)this, this.getVoxelPart(voxelProvider));
    }

    protected abstract DoubleList m_7700_(Direction.Axis var1);

    protected final void setVoxelPart(VoxelShape voxelShape, DiscreteVoxelShape part) {
        try {
            this.partField.set(voxelShape, part);
        }
        catch (IllegalAccessException ignored) {
            DiagonalFences.LOGGER.warn("Unable to set part field in {}", (Object)voxelShape.getClass().toString());
        }
    }

    protected final DiscreteVoxelShape getVoxelPart(VoxelShape voxelShape) {
        try {
            return (DiscreteVoxelShape)this.partField.get(voxelShape);
        }
        catch (IllegalAccessException ignored) {
            DiagonalFences.LOGGER.warn("Unable to get part field in {}", (Object)voxelShape.getClass().toString());
            return null;
        }
    }

    protected final DoubleList callGetValues(VoxelShape voxelShape, Direction.Axis axis) {
        try {
            return (DoubleList)this.getValuesMethod.invoke((Object)voxelShape, axis);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            DiagonalFences.LOGGER.warn("Unable to call 'getValues' method in {}", (Object)voxelShape.getClass().toString());
            return null;
        }
    }
}

