/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.electronwill.nightconfig.core.utils.StringUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.ModContext;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.RegistryLookup;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.def.SimpleBlockDefinition;
import snownee.kiwi.client.model.RetextureModel;
import snownee.kiwi.command.KiwiCommand;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.AnnotatedTypeLoader;
import snownee.kiwi.loader.KiwiConfiguration;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;
import snownee.kiwi.network.Networking;
import snownee.kiwi.schedule.Scheduler;
import snownee.kiwi.util.Util;

@Mod(value="kiwi")
public class Kiwi {
    public static final String MODID = "kiwi";
    public static final String NAME = "Kiwi";
    public static Logger logger = LogManager.getLogger((String)"Kiwi");
    static final Marker MARKER = MarkerManager.getMarker((String)"Init");
    private static Multimap<String, KiwiAnnotationData> moduleData = ArrayListMultimap.create();
    public static Map<ResourceLocation, Boolean> defaultOptions = Maps.newHashMap();
    private static Map<KiwiAnnotationData, String> conditions = Maps.newHashMap();
    private static RegistryLookup registryLookup = new RegistryLookup();
    private static LoadingStage stage = LoadingStage.UNINITED;
    private static Map<String, CreativeModeTab> GROUP_CACHE = Maps.newHashMap();
    private static boolean tagsUpdated;

    public Kiwi() throws Exception {
        if (stage != LoadingStage.UNINITED) {
            return;
        }
        stage = LoadingStage.CONSTRUCTED;
        try {
            Kiwi.registerRegistries();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap classOptionalMap = Maps.newHashMap();
        String dist = Platform.isPhysicalClient() ? "client" : "server";
        List<String> mods = ModList.get().getMods().stream().map(IModInfo::getModId).toList();
        for (String mod : mods) {
            AnnotatedTypeLoader loader;
            KiwiConfiguration configuration;
            if ("minecraft".equals(mod) || "forge".equals(mod) || (configuration = (loader = new AnnotatedTypeLoader(mod)).get()) == null) continue;
            for (KiwiAnnotationData module : configuration.modules) {
                if (!Kiwi.checkDist(module, dist)) continue;
                moduleData.put((Object)mod, (Object)module);
            }
            for (KiwiAnnotationData optional : configuration.optionals) {
                if (!Kiwi.checkDist(optional, dist)) continue;
                classOptionalMap.put(optional.target(), optional);
            }
            for (KiwiAnnotationData condition : configuration.conditions) {
                if (!Kiwi.checkDist(condition, dist)) continue;
                conditions.put(condition, mod);
            }
            for (KiwiAnnotationData config : configuration.configs) {
                if (!Kiwi.checkDist(config, dist)) continue;
                KiwiConfig.ConfigType type = null;
                try {
                    type = KiwiConfig.ConfigType.valueOf((String)config.data().get("type"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KiwiConfig.ConfigType configType = type = type == null ? KiwiConfig.ConfigType.COMMON : type;
                if (type == KiwiConfig.ConfigType.CLIENT && !Platform.isPhysicalClient()) continue;
                try {
                    boolean master;
                    Class<?> clazz = Class.forName(config.target());
                    String fileName = (String)config.data().get("value");
                    boolean bl = master = type == KiwiConfig.ConfigType.COMMON && Strings.isNullOrEmpty((String)fileName);
                    if (Strings.isNullOrEmpty((String)fileName)) {
                        fileName = String.format("%s-%s", mod, type.extension());
                    }
                    new ConfigHandler(mod, fileName, type, clazz, master);
                }
                catch (ClassNotFoundException e) {
                    logger.catching((Throwable)e);
                }
            }
            for (KiwiAnnotationData packet : configuration.packets) {
                if (!Kiwi.checkDist(packet, dist)) continue;
                Networking.processClass(packet.target(), mod);
            }
        }
        logger.info(MARKER, "Processing " + moduleData.size() + " KiwiModule annotations");
        for (Map.Entry entry : moduleData.entries()) {
            Boolean defaultEnabled;
            String modid;
            KiwiAnnotationData optional = (KiwiAnnotationData)classOptionalMap.get(((KiwiAnnotationData)entry.getValue()).target());
            if (optional == null || !Platform.isModLoaded(modid = (String)entry.getKey())) continue;
            String name = (String)((KiwiAnnotationData)entry.getValue()).data().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if ((defaultEnabled = (Boolean)optional.data().get("defaultEnabled")) == null) {
                defaultEnabled = Boolean.TRUE;
            }
            defaultOptions.put(new ResourceLocation(modid, name), defaultEnabled);
        }
        KiwiConfigManager.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::init);
        modEventBus.addListener(this::clientInit);
        MinecraftForge.EVENT_BUS.addListener(this::serverInit);
        modEventBus.addListener(this::postInit);
        modEventBus.addListener(this::loadComplete);
        modEventBus.register(KiwiModules.class);
        if (Platform.isPhysicalClient()) {
            modEventBus.addListener(this::registerModelLoader);
        }
        MinecraftForge.EVENT_BUS.addListener(this::onCommandsRegister);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsUpdated);
    }

    private static boolean checkDist(KiwiAnnotationData annotationData, String dist) throws IOException {
        try {
            ClassNode clazz = new ClassNode(458752);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(annotationData.target().replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(is);
            classReader.accept((ClassVisitor)clazz, 0);
            if (clazz.visibleAnnotations != null) {
                String ONLYIN = Type.getDescriptor(OnlyIn.class);
                for (AnnotationNode node : clazz.visibleAnnotations) {
                    int i;
                    if (node.values == null || !ONLYIN.equals(node.desc) || (i = node.values.indexOf("value")) == -1 || node.values.get(i + 1).equals(dist)) continue;
                    return false;
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static void preInit() {
        Iterator module;
        if (stage != LoadingStage.CONSTRUCTED) {
            return;
        }
        stage = LoadingStage.INITED;
        try {
            KiwiConfigManager.preload();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.fatal(MARKER, "Kiwi failed to start up. Please report this to developer!");
            logger.catching((Throwable)e);
            return;
        }
        HashSet disabledModules = Sets.newHashSet();
        conditions.forEach((k, v) -> {
            try {
                Class<?> clazz = Class.forName(k.target());
                String methodName = (String)k.data().get("method");
                List<String> values = (List<String>)k.data().get("value");
                if (values == null) {
                    values = Arrays.asList(v);
                }
                List ids = values.stream().map(s -> Kiwi.checkPrefix(s, v)).collect(Collectors.toList());
                for (ResourceLocation id : ids) {
                    LoadingContext context = new LoadingContext(id);
                    try {
                        Boolean bl = (Boolean)MethodUtils.invokeExactStaticMethod(clazz, (String)methodName, (Object[])new Object[]{context});
                        if (bl.booleanValue()) continue;
                        disabledModules.add(id);
                    }
                    catch (Exception e) {
                        disabledModules.add(id);
                        throw e;
                        return;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error(MARKER, "Failed to access to LoadingCondition: {}", k);
                logger.catching((Throwable)e);
            }
        });
        HashMap infos = Maps.newHashMap();
        boolean checkDep = false;
        block10: for (Map.Entry entry : moduleData.entries()) {
            ResourceLocation rl;
            module = (KiwiAnnotationData)entry.getValue();
            String string = (String)entry.getKey();
            if (!Platform.isModLoaded(string)) continue;
            Object name = (String)((KiwiAnnotationData)((Object)module)).data().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if (disabledModules.contains(rl = new ResourceLocation(string, (String)name))) {
                if (KiwiConfigManager.modules.containsKey(rl)) continue;
                throw new RuntimeException("Cannot load mandatory module: " + rl);
            }
            if (KiwiConfigManager.modules.containsKey(rl) && !((Boolean)KiwiConfigManager.modules.get(rl).get()).booleanValue()) continue;
            Info info = new Info(rl, ((KiwiAnnotationData)((Object)module)).target());
            String dependencies = (String)((KiwiAnnotationData)((Object)module)).data().get("dependencies");
            List rules = StringUtils.split((String)Strings.nullToEmpty((String)dependencies), (char)';').stream().filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList());
            for (String rule : rules) {
                if (rule.startsWith("@")) {
                    info.moduleRules.add(Util.RL(rule.substring(1), string));
                    checkDep = true;
                    continue;
                }
                if (Platform.isModLoaded(rule)) continue;
                continue block10;
            }
            infos.put(rl, info);
        }
        Object moduleLoadingQueue = null;
        if (checkDep) {
            LinkedList errorList = Lists.newLinkedList();
            block12: for (Info info : infos.values()) {
                for (ResourceLocation id : info.moduleRules) {
                    if (infos.containsKey(id)) continue;
                    errorList.add(info);
                    continue block12;
                }
            }
            module = errorList.iterator();
            while (module.hasNext()) {
                Info info = (Info)module.next();
                IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(info.id.m_135827_()).get()).getModInfo();
                String dependencies = org.apache.commons.lang3.StringUtils.join(info.moduleRules, (String)", ");
                ModLoader.get().addWarning(new ModLoadingWarning(modInfo, ModLoadingStage.ERROR, "msg.kiwi.no_dependencies", new Object[]{info.id, dependencies}));
            }
            if (!errorList.isEmpty()) {
                return;
            }
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(infos.size()).build();
            infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
            infos.values().forEach($ -> $.moduleRules.forEach(r -> graph.putEdge(r, (Object)$.id)));
            moduleLoadingQueue = TopologicalSort.topologicalSort((Graph)graph, null);
        } else {
            moduleLoadingQueue = ImmutableList.copyOf(infos.keySet());
        }
        for (ResourceLocation id : moduleLoadingQueue) {
            Info info = (Info)infos.get(id);
            ModContext context = ModContext.get(id.m_135827_());
            context.setActiveContainer();
            try {
                Class<?> clazz = Class.forName(info.className);
                AbstractModule instance = (AbstractModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                KiwiModules.add(id, instance, context);
            }
            catch (Exception e) {
                logger.error(MARKER, "Kiwi failed to initialize module class: {}", (Object)info.className);
                logger.catching((Throwable)e);
                continue;
            }
            ModLoadingContext.get().setActiveContainer(null);
        }
        moduleData.clear();
        moduleData = null;
        defaultOptions.clear();
        defaultOptions = null;
        conditions.clear();
        conditions = null;
        Object2IntArrayMap counter = new Object2IntArrayMap();
        for (ModuleInfo moduleInfo : KiwiModules.get()) {
            String val;
            KiwiModule.Category group;
            boolean useOwnGroup;
            counter.clear();
            moduleInfo.context.setActiveContainer();
            KiwiModule.Subscriber subscriber = moduleInfo.module.getClass().getDeclaredAnnotation(KiwiModule.Subscriber.class);
            if (subscriber != null && ArrayUtils.contains((Object[])subscriber.side(), (Object)FMLEnvironment.dist)) {
                subscriber.value().bus().get().register((Object)moduleInfo.module);
            }
            boolean bl = useOwnGroup = moduleInfo.category == null;
            if (useOwnGroup && (group = moduleInfo.module.getClass().getDeclaredAnnotation(KiwiModule.Category.class)) != null && !(val = group.value()).isEmpty()) {
                useOwnGroup = false;
                CreativeModeTab itemGroup = Kiwi.getGroup(val);
                if (itemGroup != null) {
                    moduleInfo.category = itemGroup;
                }
            }
            String modid = moduleInfo.module.uid.m_135827_();
            Item.Properties tmpBuilder = null;
            Field tmpBuilderField = null;
            for (Field field : moduleInfo.module.getClass().getFields()) {
                Object registry;
                int mods;
                if (field.getAnnotation(KiwiModule.Skip.class) != null || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods)) continue;
                KiwiModule.Name nameAnnotation = field.getAnnotation(KiwiModule.Name.class);
                ResourceLocation regName = nameAnnotation != null ? Kiwi.checkPrefix(nameAnnotation.value(), modid) : Kiwi.checkPrefix(field.getName().toLowerCase(Locale.ENGLISH), modid);
                if (field.getType() == moduleInfo.module.getClass() && "instance".equals(regName.m_135815_()) && regName.m_135827_().equals(modid)) {
                    try {
                        field.set(null, moduleInfo.module);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        logger.error(MARKER, "Kiwi failed to inject module instance to module class: {}", (Object)moduleInfo.module.uid);
                        logger.catching((Throwable)e);
                    }
                    continue;
                }
                Object o = null;
                try {
                    o = field.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error(MARKER, "Kiwi failed to catch game object: {}", (Object)field);
                    logger.catching((Throwable)e);
                }
                if (o == null) continue;
                if (useOwnGroup && moduleInfo.category == null && o instanceof CreativeModeTab) {
                    moduleInfo.category = (CreativeModeTab)o;
                } else if (o instanceof Item.Properties) {
                    tmpBuilder = (Item.Properties)o;
                    tmpBuilderField = field;
                    continue;
                }
                if (o instanceof KiwiGO) {
                    o = ((KiwiGO)o).create();
                }
                if ((registry = registryLookup.findRegistry(o)) != null) {
                    if (o instanceof Block) {
                        if (field.getAnnotation(KiwiModule.NoItem.class) != null) {
                            moduleInfo.noItems.add((Block)o);
                        }
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                        if (tmpBuilder != null) {
                            moduleInfo.blockItemBuilders.put((Block)o, tmpBuilder);
                            try {
                                tmpBuilderField.set(moduleInfo.module, null);
                            }
                            catch (Exception e) {
                                logger.error(MARKER, "Kiwi failed to clean used item builder: {}", (Object)tmpBuilderField);
                                logger.catching((Throwable)e);
                            }
                        }
                    } else if (o instanceof Item) {
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                    }
                    moduleInfo.register(o, regName, registry, field);
                }
                tmpBuilder = null;
                tmpBuilderField = null;
            }
        }
        KiwiModules.fire(ModuleInfo::preInit);
        ModLoadingContext.get().setActiveContainer(null);
    }

    public static void registerRegistry(Registry<?> registry, Class<?> baseClass) {
        Kiwi.registryLookup.registries.put(baseClass, registry);
    }

    public static void registerRegistry(IForgeRegistry<?> registry, Class<?> baseClass) {
        Kiwi.registryLookup.registries.put(baseClass, registry);
    }

    private static <T> void registerRegistries() throws Exception {
        Kiwi.registerRegistry(Registry.f_175412_, GameEvent.class);
        Kiwi.registerRegistry(ForgeRegistries.SOUND_EVENTS, SoundEvent.class);
        Kiwi.registerRegistry(ForgeRegistries.FLUIDS, Fluid.class);
        Kiwi.registerRegistry(ForgeRegistries.MOB_EFFECTS, MobEffect.class);
        Kiwi.registerRegistry(ForgeRegistries.BLOCKS, Block.class);
        Kiwi.registerRegistry(ForgeRegistries.ENCHANTMENTS, Enchantment.class);
        Kiwi.registerRegistry(ForgeRegistries.ENTITIES, EntityType.class);
        Kiwi.registerRegistry(ForgeRegistries.ITEMS, Item.class);
        Kiwi.registerRegistry(ForgeRegistries.POTIONS, Potion.class);
        Kiwi.registerRegistry(ForgeRegistries.PARTICLE_TYPES, ParticleType.class);
        Kiwi.registerRegistry(ForgeRegistries.BLOCK_ENTITIES, BlockEntityType.class);
        Kiwi.registerRegistry(ForgeRegistries.PAINTING_TYPES, Motive.class);
        Kiwi.registerRegistry(Registry.f_122832_, ResourceLocation.class);
        Kiwi.registerRegistry(ForgeRegistries.CHUNK_STATUS, ChunkStatus.class);
        Kiwi.registerRegistry(Registry.f_122861_, RuleTestType.class);
        Kiwi.registerRegistry(Registry.f_122862_, PosRuleTestType.class);
        Kiwi.registerRegistry(ForgeRegistries.CONTAINERS, MenuType.class);
        Kiwi.registerRegistry(Registry.f_122864_, RecipeType.class);
        Kiwi.registerRegistry(ForgeRegistries.RECIPE_SERIALIZERS, RecipeSerializer.class);
        Kiwi.registerRegistry(ForgeRegistries.ATTRIBUTES, Attribute.class);
        Kiwi.registerRegistry(Registry.f_175420_, PositionSourceType.class);
        Kiwi.registerRegistry(ForgeRegistries.STAT_TYPES, StatType.class);
        Kiwi.registerRegistry(Registry.f_122868_, VillagerType.class);
        Kiwi.registerRegistry(ForgeRegistries.PROFESSIONS, VillagerProfession.class);
        Kiwi.registerRegistry(ForgeRegistries.POI_TYPES, PoiType.class);
        Kiwi.registerRegistry(ForgeRegistries.MEMORY_MODULE_TYPES, MemoryModuleType.class);
        Kiwi.registerRegistry(ForgeRegistries.SENSOR_TYPES, SensorType.class);
        Kiwi.registerRegistry(ForgeRegistries.SCHEDULES, Schedule.class);
        Kiwi.registerRegistry(ForgeRegistries.ACTIVITIES, Activity.class);
        Kiwi.registerRegistry(Registry.f_122875_, LootPoolEntryType.class);
        Kiwi.registerRegistry(Registry.f_122876_, LootItemFunctionType.class);
        Kiwi.registerRegistry(Registry.f_122877_, LootItemConditionType.class);
        Kiwi.registerRegistry(Registry.f_175421_, LootNumberProviderType.class);
        Kiwi.registerRegistry(Registry.f_175422_, LootNbtProviderType.class);
        Kiwi.registerRegistry(Registry.f_175413_, LootScoreProviderType.class);
        Kiwi.registerRegistry(Registry.f_175415_, FloatProviderType.class);
        Kiwi.registerRegistry(Registry.f_175417_, IntProviderType.class);
        Kiwi.registerRegistry(Registry.f_175419_, HeightProviderType.class);
        Kiwi.registerRegistry(Registry.f_194566_, BlockPredicateType.class);
        Kiwi.registerRegistry(ForgeRegistries.WORLD_CARVERS, WorldCarver.class);
        Kiwi.registerRegistry(ForgeRegistries.FEATURES, Feature.class);
        Kiwi.registerRegistry(ForgeRegistries.STRUCTURE_FEATURES, StructureFeature.class);
        Kiwi.registerRegistry(Registry.f_205930_, StructurePlacementType.class);
        Kiwi.registerRegistry(Registry.f_122843_, StructurePieceType.class);
        Kiwi.registerRegistry(Registry.f_194570_, PlacementModifierType.class);
        Kiwi.registerRegistry(ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, BlockStateProviderType.class);
        Kiwi.registerRegistry(ForgeRegistries.FOLIAGE_PLACER_TYPES, FoliagePlacerType.class);
        Kiwi.registerRegistry(Registry.f_122859_, TrunkPlacerType.class);
        Kiwi.registerRegistry(ForgeRegistries.TREE_DECORATOR_TYPES, TreeDecoratorType.class);
        Kiwi.registerRegistry(Registry.f_122888_, FeatureSizeType.class);
        Kiwi.registerRegistry(Registry.f_122889_, Codec.class);
        Kiwi.registerRegistry(Registry.f_122890_, Codec.class);
        Kiwi.registerRegistry(Registry.f_194573_, Codec.class);
        Kiwi.registerRegistry(Registry.f_194574_, Codec.class);
        Kiwi.registerRegistry(Registry.f_211076_, Codec.class);
        Kiwi.registerRegistry(Registry.f_122891_, StructureProcessorType.class);
        Kiwi.registerRegistry(Registry.f_122892_, StructurePoolElementType.class);
    }

    static CreativeModeTab getGroup(String path) {
        if (GROUP_CACHE == null) {
            return null;
        }
        return GROUP_CACHE.computeIfAbsent(path, $ -> {
            for (CreativeModeTab group : CreativeModeTab.f_40748_) {
                if (!path.equals(group.m_40783_())) continue;
                return group;
            }
            return null;
        });
    }

    private static void checkNoGroup(ModuleInfo info, Field field, Object o) {
        if (field.getAnnotation(KiwiModule.NoCategory.class) != null) {
            info.noCategories.add(o);
        }
    }

    private void init(FMLCommonSetupEvent event) {
        KiwiConfigManager.refresh();
        InitEvent e = new InitEvent((ParallelDispatchEvent)event);
        KiwiModules.fire(m -> m.init(e));
        ModLoadingContext.get().setActiveContainer(null);
        BlockDefinition.registerFactory(SimpleBlockDefinition.Factory.INSTANCE);
    }

    private void clientInit(FMLClientSetupEvent event) {
        if (GROUP_CACHE == null) {
            return;
        }
        ClientInitEvent e = new ClientInitEvent((ParallelDispatchEvent)event);
        KiwiModules.fire(m -> m.clientInit(e));
        ModLoadingContext.get().setActiveContainer(null);
    }

    private void serverInit(ServerStartingEvent event) {
        if (GROUP_CACHE == null) {
            return;
        }
        ServerInitEvent e = new ServerInitEvent();
        KiwiModules.fire(m -> m.serverInit(e));
        event.getServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(Scheduler::load, () -> Scheduler.INSTANCE, "kiwi-schedule");
        ModLoadingContext.get().setActiveContainer(null);
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        KiwiCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getEnvironment());
    }

    private void postInit(InterModProcessEvent event) {
        PostInitEvent e = new PostInitEvent((ParallelDispatchEvent)event);
        KiwiModules.fire(m -> m.postInit(e));
        ModLoadingContext.get().setActiveContainer(null);
        KiwiModules.clear();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        GROUP_CACHE.clear();
        GROUP_CACHE = null;
    }

    public static boolean isLoaded(ResourceLocation module) {
        return KiwiModules.isLoaded(module);
    }

    private static ResourceLocation checkPrefix(String name, String defaultModid) {
        if (name.contains(":")) {
            return new ResourceLocation(name);
        }
        return new ResourceLocation(defaultModid, name);
    }

    private void onTagsUpdated(TagsUpdatedEvent event) {
        tagsUpdated = true;
    }

    public static boolean areTagsUpdated() {
        return tagsUpdated;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerModelLoader(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.RL("kiwi:retexture"), (IModelLoader)RetextureModel.Loader.INSTANCE);
    }

    private static enum LoadingStage {
        UNINITED,
        CONSTRUCTED,
        INITED;

    }

    private static final class Info {
        final ResourceLocation id;
        final String className;
        final List<ResourceLocation> moduleRules = Lists.newLinkedList();

        public Info(ResourceLocation id, String className) {
            this.id = id;
            this.className = className;
        }
    }
}

