/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientTradingOffice {
    private static Map<UUID, UniversalTraderData> loadedTraders = new HashMap<UUID, UniversalTraderData>();
    private static Map<UUID, Team> loadedTeams = new HashMap<UUID, Team>();
    private static Map<UUID, BankAccount> loadedBankAccounts = new HashMap<UUID, BankAccount>();
    private static NotificationData myNotifications = new NotificationData();
    private static BankAccount.AccountReference lastSelectedAccount = null;

    public static List<UniversalTraderData> getTraderList() {
        return loadedTraders.values().stream().collect(Collectors.toList());
    }

    public static UniversalTraderData getData(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            return loadedTraders.get(traderID);
        }
        return null;
    }

    public static void clearData() {
        loadedTraders.forEach((id, data) -> data.onRemoved());
        loadedTraders.clear();
    }

    public static void updateTrader(CompoundTag compound) {
        UUID traderID = compound.m_128342_("ID");
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.get(traderID).read(compound);
        } else {
            loadedTraders.put(traderID, TradingOffice.Deserialize(compound).flagAsClient());
        }
    }

    public static void removeTrader(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            UniversalTraderData data = loadedTraders.get(traderID);
            loadedTraders.remove(traderID);
            data.onRemoved();
        }
    }

    public static List<Team> getTeamList() {
        return loadedTeams.values().stream().collect(Collectors.toList());
    }

    public static Team getTeam(UUID teamID) {
        if (loadedTeams.containsKey(teamID)) {
            return loadedTeams.get(teamID);
        }
        return null;
    }

    public static void initTeams(List<Team> teams) {
        loadedTeams.clear();
        teams.forEach(team -> loadedTeams.put(team.getID(), (Team)team));
    }

    public static void updateTeam(CompoundTag compound) {
        Team updatedTeam = Team.load(compound);
        loadedTeams.put(updatedTeam.getID(), updatedTeam);
    }

    public static void removeTeam(UUID teamID) {
        if (loadedTeams.containsKey(teamID)) {
            loadedTeams.remove(teamID);
        }
    }

    public static BankAccount getPlayerBankAccount(Player player) {
        return ClientTradingOffice.getPlayerBankAccount(player.m_142081_());
    }

    public static BankAccount getPlayerBankAccount(UUID playerID) {
        if (loadedBankAccounts.containsKey(playerID)) {
            return loadedBankAccounts.get(playerID);
        }
        LightmansCurrency.LogWarning("No bank account for player with id " + playerID.toString() + " is present on the client.");
        return new BankAccount();
    }

    public static void initBankAccounts(Map<UUID, BankAccount> bankAccounts) {
        loadedBankAccounts.clear();
        bankAccounts.forEach((id, account) -> loadedBankAccounts.put((UUID)id, (BankAccount)account));
    }

    public static void updateBankAccount(CompoundTag compound) {
        try {
            UUID owner = compound.m_128342_("Player");
            BankAccount account = new BankAccount(compound);
            if (owner != null && account != null) {
                loadedBankAccounts.put(owner, account);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateNotifications(NotificationData data) {
        myNotifications = data;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof NotificationScreen) {
            ((NotificationScreen)mc.f_91080_).reinit();
        }
    }

    public static NotificationData getNotifications() {
        return myNotifications;
    }

    public static void updateLastSelectedAccount(BankAccount.AccountReference reference) {
        lastSelectedAccount = reference;
    }

    public static BankAccount.AccountReference getLastSelectedAccount() {
        return lastSelectedAccount;
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        loadedTraders = new HashMap<UUID, UniversalTraderData>();
        loadedTeams = new HashMap<UUID, Team>();
        loadedBankAccounts = new HashMap<UUID, BankAccount>();
        myNotifications = new NotificationData();
        lastSelectedAccount = null;
    }
}

