/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NotificationTab
extends SettingsTab {
    public static final NotificationTab INSTANCE = new NotificationTab();
    PlainButton buttonToggleNotifications;
    PlainButton buttonToggleChatNotifications;
    Button buttonToggleTeamLevel;

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42584_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.settings.notifications");
    }

    private NotificationTab() {
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of((Object)"transferOwnership");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.buttonToggleNotifications = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 35, 10, 10, this::ToggleNotifications, TraderSettingsScreen.GUI_TEXTURE, 10, 200));
        this.buttonToggleChatNotifications = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 55, 10, 10, this::ToggleChatNotifications, TraderSettingsScreen.GUI_TEXTURE, 10, 200));
        int n = screen.guiLeft() + 20;
        int n2 = screen.guiTop() + 80;
        Objects.requireNonNull(screen);
        this.buttonToggleTeamLevel = screen.addRenderableTabWidget(new Button(n, n2, 200 - 40, 20, (Component)new TextComponent(""), this::ToggleTeamNotificationLevel));
        this.tick();
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.notifications.enabled"), (float)(screen.guiLeft() + 32), (float)(screen.guiTop() + 35), 0x404040);
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.notifications.chat"), (float)(screen.guiLeft() + 32), (float)(screen.guiTop() + 55), 0x404040);
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        boolean bl = this.buttonToggleTeamLevel.f_93624_ = coreSettings.getTeam() != null;
        if (this.buttonToggleTeamLevel.f_93624_) {
            TranslatableComponent message = new TranslatableComponent("gui.button.lightmanscurrency.team.bank.notifications", new Object[]{new TranslatableComponent("gui.button.lightmanscurrency.team.bank.limit." + coreSettings.getTeamNotificationLevel())});
            this.buttonToggleTeamLevel.m_93666_((Component)message);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        CoreTraderSettings settings = this.getSetting(CoreTraderSettings.class);
        if (settings != null) {
            this.buttonToggleNotifications.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, settings.notificationsEnabled() ? 200 : 220);
            this.buttonToggleChatNotifications.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, settings.notificationsToChat() ? 200 : 220);
        }
    }

    @Override
    public void closeTab() {
    }

    private void ToggleNotifications(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleNotifications(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void ToggleChatNotifications(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleChatNotifications(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void ToggleTeamNotificationLevel(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        int newLimit = Team.NextBankLimit(coreSettings.getTeamNotificationLevel());
        CompoundTag updateInfo = coreSettings.setTeamNotificationLevel(this.getPlayer(), newLimit);
        coreSettings.sendToServer(updateInfo);
    }
}

