/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class ScrollBarWidget
extends AbstractWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/scroll.png");
    public static final int WIDTH = 8;
    public static final int KNOB_HEIGHT = 29;
    public static final int SMALL_KNOB_HEIGHT = 9;
    private final IScrollable scrollable;
    public boolean smallKnob = false;
    public boolean isDragging = false;

    private int getKnobHeight() {
        return this.smallKnob ? 9 : 29;
    }

    public ScrollBarWidget(int x, int y, int height, IScrollable scrollable) {
        super(x, y, 8, height, (Component)new TextComponent(""));
        this.scrollable = scrollable;
    }

    public boolean visible() {
        return this.f_93624_ && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible() && this.isDragging) {
            this.isDragging = false;
        }
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int yPart;
        if (!this.visible()) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_93620_, this.f_93621_, 0, 0, 8, 8);
        for (int yOffset = 8; yOffset < this.f_93619_ - 8; yOffset += yPart) {
            yPart = Math.min(this.f_93619_ - 8 - yOffset, 240);
            this.m_93228_(pose, this.f_93620_, this.f_93621_ + yOffset, 0, 8, 8, yPart);
        }
        this.m_93228_(pose, this.f_93620_, this.f_93621_ + this.f_93619_ - 8, 0, 248, 8, 8);
        int knobPosition = this.isDragging ? MathUtil.clamp(mouseY - this.f_93621_ - this.getKnobHeight() / 2, 0, this.f_93619_ - this.getKnobHeight()) : this.getNaturalKnobPosition();
        this.m_93228_(pose, this.f_93620_, this.f_93621_ + knobPosition, this.smallKnob ? 16 : 8, 0, 8, this.getKnobHeight());
    }

    public void beforeWidgetRender(double mouseY) {
        if (this.isDragging) {
            this.dragKnob(mouseY);
        }
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.f_93619_ - this.getKnobHeight()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    protected void dragKnob(double mouseY) {
        if (!this.visible()) {
            this.isDragging = false;
            return;
        }
        int scroll = this.getScrollFromMouse(mouseY);
        if (this.scrollable.currentScroll() != scroll) {
            this.scrollable.setScroll(scroll);
        }
    }

    private int getScrollFromMouse(double mouseY) {
        if ((mouseY -= (double)this.getKnobHeight() / 2.0) <= (double)this.f_93621_) {
            return this.scrollable.getMinScroll();
        }
        if (mouseY >= (double)(this.f_93621_ + this.f_93619_ - this.getKnobHeight())) {
            return this.scrollable.getMaxScroll();
        }
        int deltaScroll = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (deltaScroll <= 0) {
            return Integer.MIN_VALUE;
        }
        double sectionHeight = (double)(this.f_93619_ - this.getKnobHeight()) / (double)deltaScroll;
        double yPos = (double)this.f_93621_ - sectionHeight / 2.0;
        for (int i = this.scrollable.getMinScroll(); i <= this.scrollable.getMaxScroll(); ++i) {
            if (mouseY >= yPos && mouseY < yPos + sectionHeight) {
                return i;
            }
            yPos += sectionHeight;
        }
        LightmansCurrency.LogWarning("Error getting scroll from mouse position.");
        return this.scrollable.getMinScroll();
    }

    @Deprecated
    public void onMouseDragged(double mouseX, double mouseY, int button) {
    }

    public void onMouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.m_5953_(mouseX, mouseY) && this.visible() && button == 0) {
            LightmansCurrency.LogInfo("Started dragging.");
            this.isDragging = true;
            this.dragKnob(mouseY);
        }
    }

    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && this.visible() && button == 0) {
            this.dragKnob(mouseY);
            this.isDragging = false;
            LightmansCurrency.LogInfo("Stopped dragging.");
        }
    }

    public void m_7435_(SoundManager soundManager) {
    }

    public static interface IScrollable {
        public int currentScroll();

        public void setScroll(int var1);

        default public int getMinScroll() {
            return 0;
        }

        public int getMaxScroll();

        default public boolean handleScrollWheel(double delta) {
            int scroll = this.currentScroll();
            if (delta < 0.0) {
                if (scroll < this.getMaxScroll()) {
                    this.setScroll(scroll + 1);
                    return true;
                }
            } else if (delta > 0.0 && scroll > 0) {
                this.setScroll(scroll - 1);
                return true;
            }
            return false;
        }

        public static int calculateMaxScroll(int visibleCount, int totalCount) {
            return Math.max(0, totalCount - visibleCount);
        }
    }
}

