/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class CPacketSetVisible {
    int entityID;
    boolean visible;

    public CPacketSetVisible(int entityID, boolean visible) {
        this.entityID = entityID;
        this.visible = visible;
    }

    public static void encode(CPacketSetVisible message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeBoolean(message.visible);
    }

    public static CPacketSetVisible decode(FriendlyByteBuf buffer) {
        return new CPacketSetVisible(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(CPacketSetVisible message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            Entity entity = player.f_19853_.m_6815_(message.entityID);
            if (entity != null) {
                WalletCapability.getWalletHandler(entity).ifPresent(walletHandler -> walletHandler.setVisible(message.visible));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

