/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jeresources.util.ClassScraper;
import jeresources.util.LogHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ReflectionHelper
extends ObfuscationReflectionHelper {
    public static Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class clazz, Class checkClass) {
        for (Class instanceOf : ClassScraper.getGeneralizations(clazz)) {
            if (instanceOf != checkClass) continue;
            return true;
        }
        return false;
    }

    public static <T> void injectIntoFields(Class annotationClass, Class<T> instanceClass, T instance) {
        Type annotationType = Type.getType((Class)annotationClass);
        List allScanData = ModList.get().getAllScanData();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                try {
                    Class<?> clazz = Class.forName(a.clazz().getClassName());
                    Field field = clazz.getField(a.memberName());
                    if (field.getType() != instanceClass) continue;
                    field.set(null, instance);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                    LogHelper.warn("Failed to set: {}" + a.clazz().getClassName() + "." + a.memberName(), new Object[0]);
                }
            }
        }
    }

    public static <T, E> List<T> getPrivateArrayValueAsList(Class<? super E> classToAccess, E instance, String fieldName) {
        Object array = ReflectionHelper.getPrivateValue(classToAccess, instance, (String)fieldName);
        int length = Array.getLength(array);
        ArrayList<Object> arrayList = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            arrayList.add(Array.get(array, i));
        }
        return arrayList;
    }

    public static <T, E> T[] getPrivateArrayValue(Class<? super E> classToAccess, E instance, String fieldName) {
        return ReflectionHelper.getPrivateArrayValueAsList(classToAccess, instance, fieldName).toArray();
    }
}

