/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.collect.Lists;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockModelBuilder;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.FaceRegion;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.ModelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModel
extends BaseBakedBlockModel {
    public static final ChiseledBlockBakedModel EMPTY = new ChiseledBlockBakedModel(BlockInformation.AIR, ChiselRenderType.SOLID, null, vector3d -> BlockInformation.AIR, 0L);
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Direction[] X_Faces = new Direction[]{Direction.EAST, Direction.WEST};
    private static final Direction[] Y_Faces = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] Z_Faces = new Direction[]{Direction.SOUTH, Direction.NORTH};
    private final ChiselRenderType chiselRenderType;
    private BakedQuad[] up;
    private BakedQuad[] down;
    private BakedQuad[] north;
    private BakedQuad[] south;
    private BakedQuad[] east;
    private BakedQuad[] west;
    private BakedQuad[] generic;

    private List<BakedQuad> getList(Direction side) {
        if (side != null) {
            switch (side) {
                case DOWN: {
                    return this.asList(this.down);
                }
                case EAST: {
                    return this.asList(this.east);
                }
                case NORTH: {
                    return this.asList(this.north);
                }
                case SOUTH: {
                    return this.asList(this.south);
                }
                case UP: {
                    return this.asList(this.up);
                }
                case WEST: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<BakedQuad> asList(BakedQuad[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public ChiseledBlockBakedModel(BlockInformation state, ChiselRenderType layer, IAreaAccessor data, Function<Vec3, BlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        this.chiselRenderType = layer;
        BakedModel originalModel = null;
        if (state != null && !state.isAir()) {
            originalModel = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state.getBlockState());
        }
        if (originalModel != null && data != null) {
            boolean shouldLayerRender;
            try (IProfilerSection ignoredLayerCheck = ProfilingManager.getInstance().withSection("check");){
                shouldLayerRender = layer.isRequiredForRendering(data);
            }
            if (shouldLayerRender) {
                ChiseledBlockModelBuilder builder = new ChiseledBlockModelBuilder();
                try (IProfilerSection ignoredFaceGeneration = ProfilingManager.getInstance().withSection("facegeneration");){
                    this.generateFaces(builder, data, neighborStateSupplier, primaryStateRenderSeed);
                }
                try (IProfilerSection ignoredFinalize = ProfilingManager.getInstance().withSection("finalize");){
                    this.up = builder.getSide(Direction.UP);
                    this.down = builder.getSide(Direction.DOWN);
                    this.east = builder.getSide(Direction.EAST);
                    this.west = builder.getSide(Direction.WEST);
                    this.north = builder.getSide(Direction.NORTH);
                    this.south = builder.getSide(Direction.SOUTH);
                    this.generic = builder.getSide(null);
                }
            }
        }
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (Direction e : Direction.values()) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    private void generateFaces(ChiseledBlockModelBuilder builder, IAreaAccessor accessor, Function<Vec3, BlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        ArrayList<List<FaceRegion>> resultingFaces = new ArrayList<List<FaceRegion>>();
        try (IProfilerSection ignoredFaceProcessing = ProfilingManager.getInstance().withSection("processing");){
            try (IProfilerSection ignoredXFaces = ProfilingManager.getInstance().withSection("x");){
                this.processFaces(accessor, resultingFaces, IPositionMutator.xzy(), X_Faces, Vec3::m_7096_, Vec3::m_7094_, neighborStateSupplier);
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("y");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zxy(), Y_Faces, Vec3::m_7098_, Vec3::m_7094_, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("z");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zyx(), Z_Faces, Vec3::m_7094_, Vec3::m_7098_, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
        }
        try (IProfilerSection ignoredFaceBuilding = ProfilingManager.getInstance().withSection("building");){
            float[] uvs = new float[8];
            float[] localUvs = new float[4];
            float[] pos = new float[3];
            try (IProfilerSection ignoredMerging = ProfilingManager.getInstance().withSection("merging");){
                for (List list : resultingFaces) {
                    this.mergeFaces(list);
                }
            }
            try (IProfilerSection ignoredQuadGeneration = ProfilingManager.getInstance().withSection("quadGeneration");){
                for (List list : resultingFaces) {
                    for (FaceRegion region : list) {
                        Vector3f toB;
                        Direction myFace = region.getFace();
                        Vector3f from = this.createFromVector(region);
                        Vector3f to = this.createToVector(region);
                        ModelQuadLayer[] mpc = FaceManager.getInstance().getCachedFace(region.getBlockInformation(), myFace, this.chiselRenderType.layer, primaryStateRenderSeed);
                        Vector3f fromB = switch (myFace) {
                            case Direction.UP -> {
                                toB = new Vector3f(to.m_122239_(), from.m_122260_(), to.m_122269_());
                                yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                            }
                            case Direction.EAST -> {
                                toB = new Vector3f(from.m_122239_(), to.m_122260_(), to.m_122269_());
                                yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                            }
                            case Direction.NORTH -> {
                                toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                                yield new Vector3f(from.m_122239_(), from.m_122260_(), to.m_122269_());
                            }
                            case Direction.SOUTH -> {
                                toB = new Vector3f(to.m_122239_(), to.m_122260_(), from.m_122269_());
                                yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                            }
                            case Direction.DOWN -> {
                                toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                                yield new Vector3f(from.m_122239_(), to.m_122260_(), from.m_122269_());
                            }
                            case Direction.WEST -> {
                                toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                                yield new Vector3f(to.m_122239_(), from.m_122260_(), from.m_122269_());
                            }
                            default -> throw new NullPointerException();
                        };
                        if (mpc == null) continue;
                        for (ModelQuadLayer pc : mpc) {
                            this.getFaceUvs(uvs, myFace, from, to, pc.getUvs());
                            this.extractLocalUvs(localUvs, myFace, uvs);
                            BakedQuad quad = FACE_BAKERY.m_111600_(fromB, toB, new BlockElementFace(myFace, pc.getTint(), pc.getSprite().m_118413_().toString(), new BlockFaceUV(localUvs, 0)), pc.getSprite(), myFace, new ModelState(){

                                public boolean m_7538_() {
                                    return false;
                                }
                            }, null, pc.isShade(), new ResourceLocation("chiselsandbits", "block"));
                            this.fixColorsInQuad(quad, pc.getColor());
                            if (region.isEdge()) {
                                builder.getList(myFace).add(quad);
                                continue;
                            }
                            builder.getList(null).add(quad);
                        }
                    }
                }
            }
        }
    }

    private void fixColorsInQuad(BakedQuad quad, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int renderColor = alpha << 24 | blue << 16 | green << 8 | red;
        for (int i = 3; i < 32; i += 8) {
            quad.m_111303_()[i] = renderColor;
        }
    }

    private Vector3f createFromVector(FaceRegion faceRegion) {
        Vector3f result = new Vector3f(faceRegion.getMinX(), faceRegion.getMinY(), faceRegion.getMinZ());
        result.m_122261_(16.0f);
        return result;
    }

    private Vector3f createToVector(FaceRegion faceRegion) {
        Vector3f result = new Vector3f(faceRegion.getMaxX(), faceRegion.getMaxY(), faceRegion.getMaxZ());
        result.m_122261_(16.0f);
        return result;
    }

    private void mergeFaces(List<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processFaces(final IAreaAccessor accessor, final List<List<FaceRegion>> resultingRegions, IPositionMutator analysisOrder, Direction[] potentialDirections, final Function<Vec3, Double> regionBuildingAxisValueExtractor, final Function<Vec3, Double> faceBuildingAxisValueExtractor, final Function<Vec3, BlockInformation> neighborStateSupplier) {
        final ArrayList regions = Lists.newArrayList();
        final ICullTest test = this.chiselRenderType.getTest();
        for (final Direction facing : potentialDirections) {
            final FaceBuildingState state = new FaceBuildingState();
            accessor.forEachWithPositionMutator(analysisOrder, new Consumer<IStateEntryInfo>(){

                @Override
                public void accept(IStateEntryInfo stateEntryInfo) {
                    if (!ChiseledBlockBakedModel.this.chiselRenderType.isRequiredForRendering(stateEntryInfo)) {
                        return;
                    }
                    if (state.getRegionBuildingAxisValue() != ((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        if (!regions.isEmpty()) {
                            resultingRegions.add(Lists.newArrayList((Iterable)regions));
                        }
                        regions.clear();
                        state.setCurrentRegion(null);
                    }
                    state.setRegionBuildingAxisValue((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    if (state.getFaceBuildingAxisValue() != ((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        state.setCurrentRegion(null);
                    }
                    state.setFaceBuildingAxisValue((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    Optional<FaceRegion> potentialRegionData = ChiseledBlockBakedModel.this.buildFaceRegion(accessor, facing, stateEntryInfo, test, neighborStateSupplier);
                    if (potentialRegionData.isEmpty()) {
                        state.setCurrentRegion(null);
                        return;
                    }
                    if (state.getCurrentRegion() != null && state.getCurrentRegion().extend(potentialRegionData.get())) {
                        return;
                    }
                    state.setCurrentRegion(potentialRegionData.get());
                    regions.add(potentialRegionData.get());
                }
            });
            if (!regions.isEmpty()) {
                resultingRegions.add(Lists.newArrayList((Iterable)regions));
            }
            regions.clear();
        }
    }

    private Optional<FaceRegion> buildFaceRegion(IAreaAccessor blob, Direction facing, IStateEntryInfo target, ICullTest test, Function<Vec3, BlockInformation> neighborStateSupplier) {
        return Optional.of(target).filter(stateEntryInfo -> {
            Vec3 faceOffSet = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vec3 offsetTarget = stateEntryInfo.getStartPoint().m_82549_(faceOffSet);
            if (!blob.isInside(offsetTarget)) {
                BlockInformation externalNeighborState = (BlockInformation)neighborStateSupplier.apply(offsetTarget);
                return Optional.of(externalNeighborState).map(neighborState -> test.isVisible(stateEntryInfo.getBlockInformation(), (BlockInformation)neighborState)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
            }
            return blob.getInAreaTarget(offsetTarget).map(IStateEntryInfo::getBlockInformation).map(neighborState -> test.isVisible(stateEntryInfo.getBlockInformation(), (BlockInformation)neighborState)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
        }).map(stateEntryInfo -> {
            Vec3 faceOffSet = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vec3 offsetTarget = stateEntryInfo.getStartPoint().m_82549_(faceOffSet);
            return FaceRegion.createFrom3DObjectWithFacing(stateEntryInfo.getStartPoint(), stateEntryInfo.getEndPoint(), facing, stateEntryInfo.getBlockInformation(), !blob.isInside(offsetTarget));
        });
    }

    private void getFaceUvs(float[] uvs, Direction face, Vector3f from, Vector3f to, float[] quadsUV) {
        float to_u = 0.0f;
        float to_v = 0.0f;
        float from_u = 0.0f;
        float from_v = 0.0f;
        switch (face) {
            case UP: {
                to_u = 1.0f - to.m_122239_() / 16.0f;
                to_v = 1.0f - to.m_122269_() / 16.0f;
                from_u = 1.0f - from.m_122239_() / 16.0f;
                from_v = 1.0f - from.m_122269_() / 16.0f;
                break;
            }
            case DOWN: {
                to_u = 1.0f - to.m_122239_() / 16.0f;
                to_v = from.m_122269_() / 16.0f;
                from_u = 1.0f - from.m_122239_() / 16.0f;
                from_v = to.m_122269_() / 16.0f;
                break;
            }
            case SOUTH: {
                to_u = 1.0f - to.m_122239_() / 16.0f;
                to_v = from.m_122260_() / 16.0f;
                from_u = 1.0f - from.m_122239_() / 16.0f;
                from_v = to.m_122260_() / 16.0f;
                break;
            }
            case NORTH: {
                to_u = from.m_122239_() / 16.0f;
                to_v = from.m_122260_() / 16.0f;
                from_u = to.m_122239_() / 16.0f;
                from_v = to.m_122260_() / 16.0f;
                break;
            }
            case WEST: {
                to_u = 1.0f - to.m_122269_() / 16.0f;
                to_v = from.m_122260_() / 16.0f;
                from_u = 1.0f - from.m_122269_() / 16.0f;
                from_v = to.m_122260_() / 16.0f;
                break;
            }
            case EAST: {
                to_u = from.m_122269_() / 16.0f;
                to_v = from.m_122260_() / 16.0f;
                from_u = to.m_122269_() / 16.0f;
                from_v = to.m_122260_() / 16.0f;
                break;
            }
        }
        int[] uvOrder = this.determineUVOrder(quadsUV);
        uvs[0] = this.u(quadsUV, uvOrder, from_u, to_v) * 16.0f;
        uvs[1] = this.v(quadsUV, uvOrder, from_u, to_v) * 16.0f;
        uvs[2] = this.u(quadsUV, uvOrder, from_u, from_v) * 16.0f;
        uvs[3] = this.v(quadsUV, uvOrder, from_u, from_v) * 16.0f;
        uvs[4] = this.u(quadsUV, uvOrder, to_u, to_v) * 16.0f;
        uvs[5] = this.v(quadsUV, uvOrder, to_u, to_v) * 16.0f;
        uvs[6] = this.u(quadsUV, uvOrder, to_u, from_v) * 16.0f;
        uvs[7] = this.v(quadsUV, uvOrder, to_u, from_v) * 16.0f;
        ChiseledBlockBakedModel.cleanUvs(uvs);
    }

    private int[] determineUVOrder(float[] quadsUV) {
        int[] uvOrder = new int[8];
        float minU = Math.min(Math.min(quadsUV[0], quadsUV[2]), Math.min(quadsUV[4], quadsUV[6]));
        float maxU = Math.max(Math.max(quadsUV[0], quadsUV[2]), Math.max(quadsUV[4], quadsUV[6]));
        float minV = Math.min(Math.min(quadsUV[1], quadsUV[3]), Math.min(quadsUV[5], quadsUV[7]));
        float maxV = Math.max(Math.max(quadsUV[1], quadsUV[3]), Math.max(quadsUV[5], quadsUV[7]));
        for (int i = 0; i < 4; ++i) {
            int uIndex = i * 2;
            int vIndex = uIndex + 1;
            float u = quadsUV[uIndex];
            float v = quadsUV[vIndex];
            if (ModelUtil.is(u, minU) && ModelUtil.is(v, maxV)) {
                uvOrder[4] = uIndex;
                uvOrder[5] = vIndex;
            }
            if (ModelUtil.is(u, minU) && ModelUtil.is(v, minV)) {
                uvOrder[0] = uIndex;
                uvOrder[1] = vIndex;
            }
            if (ModelUtil.is(u, maxU) && ModelUtil.is(v, maxV)) {
                uvOrder[6] = uIndex;
                uvOrder[7] = vIndex;
            }
            if (!ModelUtil.is(u, maxU) || !ModelUtil.is(v, minV)) continue;
            uvOrder[2] = uIndex;
            uvOrder[3] = vIndex;
        }
        return uvOrder;
    }

    float u(float[] src, int[] uvOrder, float inU, float inV) {
        float inv = 1.0f - inU;
        float u1 = src[uvOrder[0]] * inU + inv * src[uvOrder[2]];
        float u2 = src[uvOrder[4]] * inU + inv * src[uvOrder[6]];
        return u1 * inV + (1.0f - inV) * u2;
    }

    float v(float[] src, int[] uvOrder, float inU, float inV) {
        float inv = 1.0f - inU;
        float v1 = src[uvOrder[1]] * inU + inv * src[uvOrder[3]];
        float v2 = src[uvOrder[5]] * inU + inv * src[uvOrder[7]];
        return v1 * inV + (1.0f - inV) * v2;
    }

    private static void cleanUvs(float[] uvs) {
        for (int i = 0; i < uvs.length; ++i) {
            uvs[i] = Math.round(uvs[i]);
        }
    }

    private void extractLocalUvs(float[] localUvs, Direction myFace, float[] uvs) {
        switch (myFace) {
            case DOWN: 
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case UP: 
            case WEST: {
                localUvs[0] = uvs[2];
                localUvs[1] = uvs[3];
                localUvs[2] = uvs[4];
                localUvs[3] = uvs[5];
            }
        }
    }

    @NotNull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand) {
        return this.getList(side);
    }

    public boolean m_7547_() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    private static final class FaceBuildingState {
        private double regionBuildingAxis = -1.0;
        private double faceBuildingAxis = -1.0;
        private FaceRegion currentRegion;

        private FaceBuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public FaceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(FaceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}

