/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.platforms.core.client.models.data.IBlockModelData;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    private static final SimpleMaxSizedCache<CompoundTag, BakedModel> STACK_MODEL_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getStackModelCacheSize())::get);

    @Override
    public boolean m_7541_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    @Override
    public BakedModel handleBlockState(BlockState state, Random random, IBlockModelData modelData) {
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) && !modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) || IRenderTypeManager.getInstance().getCurrentRenderType().isEmpty()) {
            return modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
        }
        return modelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY).getOrDefault(IRenderTypeManager.getInstance().getCurrentRenderType().get(), NullBakedModel.instance);
    }

    @Override
    public BakedModel resolve(BakedModel originalModel, ItemStack stack, Level world, LivingEntity entity) {
        Item item = stack.m_41720_();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        CompoundTag cacheKey = stack.m_41739_(new CompoundTag());
        return STACK_MODEL_CACHE.get(cacheKey, () -> {
            BakedModel[] typedModels;
            IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
                typedModels = (BakedModel[])Arrays.stream(VoxelType.values()).map(ChiselRenderType::getRenderTypes).filter(types -> !types.isEmpty()).map(types -> {
                    BakedModel[] models = (BakedModel[])types.stream().map(type -> ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, (ChiselRenderType)((Object)((Object)((Object)type))))).filter(Optional::isPresent).map(Optional::get).filter(model -> !model.isEmpty()).toArray(BakedModel[]::new);
                    if (models.length == 0) {
                        return ChiseledBlockBakedModel.EMPTY;
                    }
                    return new CombinedModel(models);
                }).toArray(BakedModel[]::new);
            }
            if (typedModels.length == 0) {
                return ChiseledBlockBakedModel.EMPTY;
            }
            ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
            try {
                CombinedModel combinedModel = new CombinedModel(typedModels);
                return combinedModel;
            }
            finally {
                if (ignored1 != null) {
                    ignored1.close();
                }
            }
        });
    }
}

