/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier;

import com.mojang.brigadier.CommandDispatcher;
import net.dark_roleplay.projectbrazier.ProjectBrazierClient;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.creative_tabs.CreativeTabFixedData;
import net.dark_roleplay.projectbrazier.feature.mechanics.spreader.SpreadBehaviors;
import net.dark_roleplay.projectbrazier.feature.mechanics.spreader.SpreaderType;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierCommands;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierContainers;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierEntities;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierItems;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierPackets;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierRegistries;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierSounds;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierWorldGen;
import net.dark_roleplay.projectbrazier.tests.GameTestDemo;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.NewRegistryEvent;

@Mod(value="projectbrazier")
public class ProjectBrazier {
    public static final String MODID = "projectbrazier";

    public ProjectBrazier() {
        if (!ModList.get().isLoaded("marg")) {
            return;
        }
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BrazierPackets.registerPackets();
        MinecraftForge.EVENT_BUS.addListener(BrazierCommands::registerCommands);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BrazierWorldGen::setup);
        MinecraftForge.EVENT_BUS.addListener(BrazierWorldGen::biomeLoad);
        MinecraftForge.EVENT_BUS.addListener(ProjectBrazier::registerCommands);
        modEventBus.addListener(CreativeTabFixedData::load);
        modEventBus.addGenericListener(Item.class, BrazierRegistries.ITEMS_FD::registryListener);
        BrazierRegistries.BLOCKS.register(modEventBus);
        BrazierRegistries.BLOCKS_NO_ITEMS.register(modEventBus);
        BrazierRegistries.BLOCK_ENTITIES.register(modEventBus);
        BrazierRegistries.ITEMS.register(modEventBus);
        BrazierRegistries.CONTAINERS.register(modEventBus);
        BrazierRegistries.ENTITIES.register(modEventBus);
        BrazierRegistries.SOUNDS.register(modEventBus);
        BrazierRegistries.FEATURES.register(modEventBus);
        modEventBus.addListener(this::hackyHackToByPassLoadingOrder);
        modEventBus.addListener(this::setupCommonStuff);
        modEventBus.addListener(this::setupServerStuff);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ProjectBrazierClient::modConstructor);
    }

    public void hackyHackToByPassLoadingOrder(NewRegistryEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BrazierBlocks.preRegistry();
        BrazierBlockEntities.preRegistry();
        BrazierItems.preRegistry();
        BrazierContainers.preRegistry();
        BrazierEntities.preRegistry();
        BrazierSounds.preRegistry();
        BrazierWorldGen.preRegistry();
        modEventBus.addListener(BrazierBlocks::postRegistry);
        modEventBus.addListener(BrazierBlockEntities::postRegistry);
        modEventBus.addGenericListener(Item.class, BrazierItems::registerItemBlocks);
        modEventBus.addListener(BrazierItems::postRegistry);
        modEventBus.addListener(BrazierContainers::postRegistry);
        modEventBus.addListener(BrazierEntities::postRegistry);
        modEventBus.addListener(BrazierSounds::postRegistry);
    }

    public void setupCommonStuff(FMLCommonSetupEvent event) {
        SpreadBehaviors.addSpreaderBehavior((Block)BrazierBlocks.CLAY_IN_DIRT.get(), SpreaderType.GRASS, (state, level, pos) -> (BlockState)((Block)BrazierBlocks.CLAY_IN_GRASSY_DIRT.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50125_))));
        SpreadBehaviors.addSpreaderBehavior((Block)BrazierBlocks.CLAY_IN_GRASSY_DIRT.get(), SpreaderType.REVERT, (state, level, pos) -> ((Block)BrazierBlocks.CLAY_IN_DIRT.get()).m_49966_());
        SpreadBehaviors.addSpreaderBehavior(Blocks.f_50493_, SpreaderType.GRASS, (state, level, pos) -> (BlockState)Blocks.f_50440_.m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50125_))));
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        TestCommand.m_127946_((CommandDispatcher)event.getDispatcher());
        GameTestRegistry.m_177501_(GameTestDemo.class);
    }

    public void setupServerStuff(FMLDedicatedServerSetupEvent event) {
    }

    static {
        if (!FMLEnvironment.production) {
            // empty if block
        }
    }
}

