/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.CodecUtil;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.FixedDataPack;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.items.ItemCodecs;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.util.ForgeFixedData;
import net.dark_roleplay.projectbrazier.experimental_features.link.either_codec_registry.CodecDispatchRegistry;
import net.dark_roleplay.projectbrazier.experimental_features.link.either_codec_registry.CodecDispatchType;
import net.dark_roleplay.projectbrazier.experimental_features.selective_item_block.SelectiveBlockItem;
import net.dark_roleplay.projectbrazier.feature.items.DryClayItem;
import net.dark_roleplay.projectbrazier.feature.items.PlantSeedsItem;
import net.dark_roleplay.projectbrazier.feature.items.SpyglassItem;
import net.dark_roleplay.projectbrazier.feature.items.WarHornItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemFixedDataRegistry
extends ForgeFixedData<Item> {
    private static final CodecDispatchRegistry<Item> ITEM_PROVIDER = new CodecDispatchRegistry();

    public ItemFixedDataRegistry(IForgeRegistry<Item> registry, String namespace) {
        super(registry, namespace);
    }

    @Override
    protected Set<Item> loadObjects() {
        HashSet<Item> items = new HashSet<Item>();
        FixedDataPack pack = FixedDataPack.getPackForMod("projectbrazier");
        Collection<ResourceLocation> itemLocations = pack.getResources("projectbrazier", "item/instances/", Integer.MAX_VALUE, file -> file.endsWith(".json"));
        for (ResourceLocation itemLocation : itemLocations) {
            try {
                String[] splitPath = itemLocation.m_135815_().split("/");
                ResourceLocation registryName = new ResourceLocation("projectbrazier", splitPath[splitPath.length - 1].replace(".json", ""));
                InputStreamReader itemStream = new InputStreamReader(pack.getResource(itemLocation));
                JsonElement element = JsonParser.parseReader((Reader)itemStream);
                try {
                    DataResult result = ITEM_PROVIDER.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    Item item = (Item)result.getOrThrow(false, err -> LOGGER.error("Failed to load item json {}", (Object)registryName, err));
                    item.setRegistryName(registryName);
                    items.add(item);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load item json {}", (Object)registryName, (Object)e);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load item json {}", (Object)itemLocation, (Object)e);
            }
        }
        return items;
    }

    static {
        ITEM_PROVIDER.register(new CodecDispatchType<Item>(new ResourceLocation("projectbrazier", "item"), Item.class, MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)CodecUtil.ITEM_PROPERTIES.map(Item::new))));
        ITEM_PROVIDER.register(new CodecDispatchType<DryClayItem>(new ResourceLocation("projectbrazier", "dry_clay"), DryClayItem.class, MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)CodecUtil.ITEM_PROPERTIES.map(DryClayItem::new))));
        ITEM_PROVIDER.register(new CodecDispatchType<WarHornItem>(new ResourceLocation("projectbrazier", "war_horn"), WarHornItem.class, MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)CodecUtil.ITEM_PROPERTIES.map(WarHornItem::new))));
        ITEM_PROVIDER.register(new CodecDispatchType<SpyglassItem>(new ResourceLocation("projectbrazier", "spyglass"), SpyglassItem.class, MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)CodecUtil.ITEM_PROPERTIES.map(SpyglassItem::new))));
        ITEM_PROVIDER.register(new CodecDispatchType<PlantSeedsItem>(new ResourceLocation("projectbrazier", "plant_seeds"), PlantSeedsItem.class, ItemCodecs.PLANT_SEED_ITEM));
        ITEM_PROVIDER.register(new CodecDispatchType<SelectiveBlockItem>(new ResourceLocation("projectbrazier", "selective_block"), SelectiveBlockItem.class, ItemCodecs.SELECTIVE_BLOCK_ITEM));
    }
}

