/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data.util;

import java.util.LinkedHashSet;
import java.util.Set;
import net.dark_roleplay.projectbrazier.experimental_features.fixed_data.util.FixedData;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public abstract class ForgeFixedData<T extends IForgeRegistryEntry<T>>
extends FixedData<T> {
    private IForgeRegistry<T> registry;
    private String namespace;
    private final Set<RegistryObject<T>> registryObjects = new LinkedHashSet<RegistryObject<T>>();

    public ForgeFixedData(IForgeRegistry<T> registry, String namespace) {
        this.registry = registry;
        this.namespace = namespace;
    }

    protected abstract Set<T> loadObjects();

    public void registryListener(RegistryEvent.Register<T> event) {
        IForgeRegistry reg = event.getRegistry();
        for (IForgeRegistryEntry iForgeRegistryEntry : this.loadObjects()) {
            event.getRegistry().register(iForgeRegistryEntry);
        }
        for (RegistryObject registryObject : this.registryObjects) {
            registryObject.updateReference(reg);
        }
    }

    public RegistryObject<T> get(String name) {
        RegistryObject robj = RegistryObject.of((ResourceLocation)new ResourceLocation(this.namespace, name), this.registry);
        this.registryObjects.add(robj);
        return robj;
    }
}

