/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.listeners;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import net.dark_roleplay.projectbrazier.feature.mechanics.tertiary_interactions.ITertiaryInteractor;
import net.dark_roleplay.projectbrazier.feature.packets.TertiaryInteractionPacket;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierPackets;
import net.dark_roleplay.projectbrazier.feature_client.registrars.BrazierKeybinds;
import net.dark_roleplay.projectbrazier.util.rendering.RenderUtils;
import net.dark_roleplay.projectbrazier.util.screens.TextureList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TertiaryInteractionListener
extends GuiComponent {
    private static long pressStart;
    private static boolean wasButtonPressed;
    private static boolean hadSuccess;
    private static BlockHitResult rayTraceResult;
    private static Pair<Vec2, Boolean> tertiaryScreenPos;

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelLastEvent event) {
        if (rayTraceResult == null || rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(rayTraceResult.m_82425_());
        if (!(state.m_60734_() instanceof ITertiaryInteractor)) {
            return;
        }
        ITertiaryInteractor block = (ITertiaryInteractor)state.m_60734_();
        if (!block.hasInteraction((BlockGetter)Minecraft.m_91087_().f_91073_, rayTraceResult.m_82425_(), state, (Player)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        Vec3 hitBlock = new Vec3((double)rayTraceResult.m_82425_().m_123341_() + 0.5, (double)rayTraceResult.m_82425_().m_123342_() + 0.5, (double)rayTraceResult.m_82425_().m_123343_() + 0.5);
        tertiaryScreenPos = RenderUtils.worldToScreenSpace(hitBlock, event.getPartialTick(), true);
        if (((Boolean)tertiaryScreenPos.getSecond()).booleanValue()) {
            hadSuccess = true;
        }
    }

    @SubscribeEvent
    public static void renderBlockOverlay(DrawSelectionEvent event) {
        if (event.getTarget().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        rayTraceResult = (BlockHitResult)event.getTarget();
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (hadSuccess) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            BlockPos pos = rayTraceResult.m_82425_();
            BlockState state = world.m_8055_(pos);
            if (!(state.m_60734_() instanceof ITertiaryInteractor)) {
                return;
            }
            ITertiaryInteractor block = (ITertiaryInteractor)state.m_60734_();
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            Vec2 screenPos = (Vec2)tertiaryScreenPos.getFirst();
            int posX = (int)screenPos.f_82470_;
            int posY = (int)screenPos.f_82471_;
            TertiaryInteractionListener.m_93215_((PoseStack)event.getMatrixStack(), (Font)fontRenderer, (Component)block.getInteractionTooltip((Level)world, pos, state, (Player)Minecraft.m_91087_().f_91074_), (int)posX, (int)(posY - 9), (int)-1);
            int width = fontRenderer.m_92852_((FormattedText)BrazierKeybinds.TER_ACTION.m_90863_()) + 7;
            if (Minecraft.m_91087_().f_91073_.m_46467_() % 30L > 15L) {
                TextureList.KEYBOARD_BUTTON.renderSegmented(event.getMatrixStack(), posX - width / 2, posY + 1, width, 13);
                fontRenderer.m_92889_(event.getMatrixStack(), BrazierKeybinds.TER_ACTION.m_90863_(), (float)(posX - width / 2 + 4), (float)(posY + 3), -1);
            } else {
                TextureList.KEYBOARD_BUTTON_PRESSED.renderSegmented(event.getMatrixStack(), posX - width / 2, posY + 1, width, 13);
                fontRenderer.m_92889_(event.getMatrixStack(), BrazierKeybinds.TER_ACTION.m_90863_(), (float)(posX - width / 2 + 4), (float)(posY + 4), -1);
            }
            if (BrazierKeybinds.TER_ACTION.m_90857_()) {
                if (!wasButtonPressed) {
                    pressStart = System.currentTimeMillis();
                    wasButtonPressed = true;
                }
                long maxDuration = block.getDurationInMS((Level)world, pos, state);
                long msPassed = System.currentTimeMillis() - pressStart;
                float percentage = Math.min((float)msPassed * 1.0f / (float)maxDuration, 1.0f);
                TertiaryInteractionListener.m_93172_((PoseStack)event.getMatrixStack(), (int)(posX - 25), (int)posY, (int)(posX + 25), (int)(posY + 9), (int)-1610612736);
                TertiaryInteractionListener.m_93172_((PoseStack)event.getMatrixStack(), (int)(posX - 24), (int)(posY + 1), (int)((int)((float)posX + Mth.m_14179_((float)percentage, (float)-24.0f, (float)24.0f))), (int)(posY + 8), (int)-1593835521);
                if (msPassed >= maxDuration) {
                    BrazierPackets.CHANNEL.sendToServer((Object)new TertiaryInteractionPacket(pos));
                    wasButtonPressed = false;
                }
            } else {
                wasButtonPressed = false;
            }
        } else {
            wasButtonPressed = false;
        }
        hadSuccess = false;
        rayTraceResult = null;
    }

    static {
        wasButtonPressed = false;
        hadSuccess = false;
    }
}

