/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.simple_pane_conneted_model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models.AxisConnectionType;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.simple_pane_conneted_model.SimplePaneModelData;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class SimplePaneConnectedModel
implements IModelGeometry {
    private final UnbakedModel baseModel;
    private final UnbakedModel priPosModel;
    private final UnbakedModel priNegModel;
    private final UnbakedModel secPosModel;
    private final UnbakedModel secNegModel;

    public SimplePaneConnectedModel(UnbakedModel baseModel, UnbakedModel priPosModel, UnbakedModel priNegModel, UnbakedModel secPosModel, UnbakedModel secNegModel) {
        this.baseModel = baseModel;
        this.priPosModel = priPosModel;
        this.priNegModel = priNegModel;
        this.secPosModel = secPosModel;
        this.secNegModel = secNegModel;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new ConnectedBakedModel(this.baseModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.priPosModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.priNegModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.secPosModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.secNegModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function modelGetter, Set missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        textures.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
        textures.addAll(this.priPosModel.m_5500_(modelGetter, missingTextureErrors));
        textures.addAll(this.priNegModel.m_5500_(modelGetter, missingTextureErrors));
        textures.addAll(this.secPosModel.m_5500_(modelGetter, missingTextureErrors));
        textures.addAll(this.secNegModel.m_5500_(modelGetter, missingTextureErrors));
        return textures;
    }

    public static class ConnectedBakedModel
    extends BakedModelWrapper {
        protected final BakedModel priPosModel;
        protected final BakedModel priNegModel;
        protected final BakedModel secPosModel;
        protected final BakedModel secNegModel;

        public ConnectedBakedModel(BakedModel baseModel, BakedModel priPosModel, BakedModel priNegModel, BakedModel secPosModel, BakedModel secNegModel) {
            super(baseModel);
            this.priPosModel = priPosModel;
            this.priNegModel = priNegModel;
            this.secPosModel = secPosModel;
            this.secNegModel = secNegModel;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            boolean flag2;
            Direction facing = state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : (state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : null);
            boolean flag = facing == Direction.NORTH || facing == Direction.EAST || facing == Direction.UP || facing == Direction.DOWN;
            boolean bl = flag2 = facing == Direction.DOWN;
            if (extraData instanceof SimplePaneModelData) {
                ArrayList<BakedQuad> totalQuads = new ArrayList<BakedQuad>();
                totalQuads.addAll(this.originalModel.getQuads(state, side, rand, extraData));
                AxisConnectionType primaryConnection = (AxisConnectionType)((Object)extraData.getData(SimplePaneModelData.PRIMARY_CONNECTION));
                if (!flag2 ? !primaryConnection.isPositive() : !primaryConnection.isNegative()) {
                    totalQuads.addAll(this.priPosModel.getQuads(state, side, rand, extraData));
                }
                if (!flag2 ? !primaryConnection.isNegative() : !primaryConnection.isPositive()) {
                    totalQuads.addAll(this.priNegModel.getQuads(state, side, rand, extraData));
                }
                AxisConnectionType secondaryConnection = (AxisConnectionType)((Object)extraData.getData(SimplePaneModelData.SECONDARY_CONNECTION));
                if (flag && !secondaryConnection.isPositive() || !flag && !secondaryConnection.isNegative()) {
                    totalQuads.addAll(this.secPosModel.getQuads(state, side, rand, extraData));
                }
                if (flag && !secondaryConnection.isNegative() || !flag && !secondaryConnection.isPositive()) {
                    totalQuads.addAll(this.secNegModel.getQuads(state, side, rand, extraData));
                }
                return totalQuads;
            }
            return this.originalModel.getQuads(state, side, rand, extraData);
        }

        @Nonnull
        public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
            SimplePaneModelData data = new SimplePaneModelData();
            boolean flag2 = false;
            boolean flag3 = false;
            boolean flag = state.m_61138_((Property)BlockStateProperties.f_61364_);
            if (flag || (flag2 = state.m_61138_((Property)BlockStateProperties.f_61365_)) || (flag3 = state.m_61138_((Property)BlockStateProperties.f_61374_)) || state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                Direction.Axis axis = flag ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_) : (flag2 ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_) : (flag3 ? ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() : ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()));
                switch (axis) {
                    case X: {
                        data.setData(SimplePaneModelData.PRIMARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.Y));
                        data.setData(SimplePaneModelData.SECONDARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.Z));
                        break;
                    }
                    case Z: {
                        data.setData(SimplePaneModelData.PRIMARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.Y));
                        data.setData(SimplePaneModelData.SECONDARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.X));
                        break;
                    }
                    case Y: {
                        data.setData(SimplePaneModelData.PRIMARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.Z));
                        data.setData(SimplePaneModelData.SECONDARY_CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state, Direction.Axis.X));
                    }
                }
            }
            return data;
        }
    }

    public static class Loader
    implements IModelLoader {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public IModelGeometry read(JsonDeserializationContext deserCtx, JsonObject modelContents) {
            JsonObject textures = GsonHelper.m_13841_((JsonObject)modelContents, (String)"textures", null);
            JsonObject primarySubContents = GsonHelper.m_13930_((JsonObject)modelContents, (String)"primary");
            JsonObject secondarySubContents = GsonHelper.m_13930_((JsonObject)modelContents, (String)"secondary");
            UnbakedModel baseModel = this.loadSubModel(deserCtx, modelContents, "base", textures);
            UnbakedModel priPosModel = this.loadSubModel(deserCtx, primarySubContents, "positive", textures);
            UnbakedModel priNegModel = this.loadSubModel(deserCtx, primarySubContents, "negative", textures);
            UnbakedModel secPosModel = this.loadSubModel(deserCtx, secondarySubContents, "positive", textures);
            UnbakedModel secNegModel = this.loadSubModel(deserCtx, secondarySubContents, "negative", textures);
            return new SimplePaneConnectedModel(baseModel, priPosModel, priNegModel, secPosModel, secNegModel);
        }

        private UnbakedModel loadSubModel(JsonDeserializationContext deserCtx, JsonObject base, String subModelName, JsonObject textures) {
            JsonObject subModelJson = GsonHelper.m_13930_((JsonObject)base, (String)subModelName);
            if (textures != null) {
                JsonObject subModelTextures = GsonHelper.m_13841_((JsonObject)base, (String)"textures", (JsonObject)new JsonObject());
                for (Map.Entry entry : textures.entrySet()) {
                    subModelTextures.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                subModelJson.add("textures", (JsonElement)subModelTextures);
            }
            return (UnbakedModel)deserCtx.deserialize((JsonElement)subModelJson, BlockModel.class);
        }
    }
}

