/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();

    public PlayerStateManager() {
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::onPlayerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::onPlayerLoggedOut);
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.m_142081_());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisconnected(packet.isDisconnected());
            state.setDisabled(packet.isDisabled());
            this.states.put(player.m_142081_(), state);
            this.broadcastState(server, state);
            Voicechat.logDebug("Got state of {}: {}", player.m_5446_().getString(), state);
        });
    }

    private void broadcastState(MinecraftServer server, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        server.m_6846_().m_11314_().forEach(p -> NetManager.sendToClient(p, packet));
    }

    public void onPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        PlayerState state = this.states.getOrDefault(player.m_142081_(), PlayerStateManager.defaultDisconnectedState(player));
        this.states.put(player.m_142081_(), state);
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        Voicechat.logDebug("Setting initial state of {}: {}", player.m_5446_().getString(), state);
    }

    private void onPlayerLoggedIn(ServerPlayer player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.m_142081_(), state);
        this.broadcastState(player.f_8924_, state);
    }

    private void onPlayerLoggedOut(ServerPlayer player) {
        this.states.remove(player.m_142081_());
        this.broadcastState(player.f_8924_, new PlayerState(player.m_142081_(), player.m_36316_().getName(), true, true));
        Voicechat.logDebug("Removing state of {}", player.m_5446_().getString());
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(ServerPlayer player) {
        return new PlayerState(player.m_142081_(), player.m_36316_().getName(), false, true);
    }

    public void setGroup(MinecraftServer server, ServerPlayer player, @Nullable ClientGroup group) {
        PlayerState state = this.states.get(player.m_142081_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.logDebug("Defaulting to default state for {}: {}", player.m_5446_().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.m_142081_(), state);
        this.broadcastState(server, state);
        Voicechat.logDebug("Setting group of {}: {}", player.m_5446_().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

