/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class CommonEventHandler {
    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        Block block;
        Player player = evt.getPlayer();
        Level world = player.m_20193_();
        BlockPos pos = evt.getNewSpawn();
        if (pos != null && !world.f_46443_ && ((block = world.m_8055_(pos).m_60734_()) instanceof SleepingBagBlock || block instanceof HammockBlock)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent evt) {
        Level world = evt.getPlayer().m_20193_();
        long worldTime = world.m_46468_() % 24000L;
        evt.getSleepingLocation().ifPresent(sleepingLocation -> {
            if (world.m_8055_(sleepingLocation).m_60734_() instanceof HammockBlock) {
                if (worldTime > 500L && worldTime < 11500L) {
                    evt.setResult(Event.Result.ALLOW);
                } else if (((Boolean)ComfortsConfig.SERVER.nightHammocks.get()).booleanValue()) {
                    evt.setResult(Event.Result.DEFAULT);
                } else {
                    evt.setResult(Event.Result.DENY);
                }
            }
        });
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        LevelAccessor world = evt.getWorld();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            boolean[] activeHammock = new boolean[]{false};
            List players = world.m_6907_();
            for (Player player : players) {
                player.m_21257_().ifPresent(bedPos -> {
                    if (player.m_36317_() && world.m_8055_(bedPos).m_60734_() instanceof HammockBlock) {
                        activeHammock[0] = true;
                    }
                });
                if (!activeHammock[0]) continue;
                break;
            }
            if (activeHammock[0] && ((ServerLevel)world).m_6018_().m_46461_()) {
                long i = serverWorld.m_46468_() + 24000L;
                evt.setTimeAddition(i - i % 24000L - 12001L);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        Player player = evt.getPlayer();
        Level world = player.f_19853_;
        if (!world.f_46443_) {
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> player.m_21257_().ifPresent(bedPos -> {
                long wakeTime = world.m_46468_();
                long timeSlept = wakeTime - sleepdata.getSleepTime();
                BlockState state = world.m_8055_(bedPos);
                if (state.m_60734_() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        List<MobEffectInstance> debuffs = ComfortsConfig.sleepingBagDebuffs;
                        if (!debuffs.isEmpty()) {
                            for (MobEffectInstance effect : debuffs) {
                                player.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_()));
                            }
                        }
                        if (world.f_46441_.nextDouble() < (Double)ComfortsConfig.SERVER.sleepingBagBreakage.get()) {
                            broke = true;
                            BlockPos blockpos = bedPos.m_142300_(((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
                            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
                            world.m_7731_(bedPos, Blocks.f_50016_.m_49966_(), 35);
                            player.m_5661_((Component)new TranslatableComponent("block.comforts.sleeping_bag.broke"), true);
                            world.m_5594_(null, bedPos, SoundEvents.f_12639_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            player.m_21258_();
                        }
                    }
                    if (!broke && sleepdata.getAutoSleepPos() != null) {
                        BlockPos blockpos = bedPos.m_142300_(((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
                        world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
                        world.m_7731_(bedPos, Blocks.f_50016_.m_49966_(), 35);
                        player.m_21258_();
                    }
                }
                sleepdata.setWakeTime(wakeTime);
                sleepdata.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.sleepyFactor.get()));
                sleepdata.setAutoSleepPos(null);
            }));
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent evt) {
        Player player = evt.getPlayer();
        CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
            if (!player.f_19853_.f_46443_) {
                long dayTime = player.m_20193_().m_46468_();
                sleepdata.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.wellRested.get()).booleanValue()) {
                    if (sleepdata.getWakeTime() > dayTime) {
                        sleepdata.setWakeTime(0L);
                        sleepdata.setTiredTime(0L);
                    }
                    if (sleepdata.getTiredTime() > dayTime) {
                        player.m_5661_((Component)new TranslatableComponent("capability.comforts.not_sleepy"), true);
                        evt.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
                    }
                }
            }
        });
    }
}

