/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.Random;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.ClientVariables;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.client.model.SnowVariantModel;

@Mixin(value={BlockRenderDispatcher.class})
public abstract class BlockRenderDispatcherMixin {
    @Shadow
    private ModelBlockRenderer f_110900_;

    @Inject(method={"renderBatched(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZLjava/util/Random;Lnet/minecraftforge/client/model/data/IModelData;)Z"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void srm_renderBatched(BlockState blockStateIn, BlockPos posIn, BlockAndTintGetter lightReaderIn, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, boolean checkSides, Random random, IModelData modelData, CallbackInfoReturnable<Boolean> ci) {
        if (!(blockStateIn.m_60734_() instanceof SnowVariant)) {
            return;
        }
        if (!blockStateIn.m_155947_()) {
            return;
        }
        if (blockStateIn.m_61138_((Property)SnowLayerBlock.f_56581_) && (Integer)blockStateIn.m_61143_((Property)SnowLayerBlock.f_56581_) == 8) {
            return;
        }
        BlockState state = (BlockState)modelData.getData(SnowBlockEntity.BLOCKSTATE);
        if (state == null || !state.m_60795_() && state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        boolean useSnowVariant = false;
        try {
            double yOffset;
            boolean canRender;
            RenderType cutoutMipped = RenderType.m_110457_();
            RenderType solid = RenderType.m_110451_();
            RenderType layer = MinecraftForgeClient.getRenderType();
            boolean ret = false;
            Block blockIn = blockStateIn.m_60734_();
            SnowBlockEntity.Options options = Optional.ofNullable((SnowBlockEntity.Options)modelData.getData(SnowBlockEntity.OPTIONS)).orElse(ClientVariables.fallbackOptions);
            if (layer == null) {
                canRender = layer == cutoutMipped;
            } else {
                if (layer == solid && blockIn instanceof WatcherSnowVariant) {
                    ((WatcherSnowVariant)blockIn).updateOptions(blockStateIn, (BlockGetter)lightReaderIn, posIn, options);
                }
                canRender = ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)layer);
            }
            if (canRender && !state.m_60795_()) {
                BakedModel snowVariant;
                matrixStackIn.m_85836_();
                if (blockStateIn.m_61138_((Property)SnowLayerBlock.f_56581_) && state.m_204336_(CoreModule.OFFSET_Y)) {
                    if ((Integer)blockStateIn.m_61143_((Property)SnowLayerBlock.f_56581_) > 3) {
                        matrixStackIn.m_85849_();
                        return;
                    }
                    matrixStackIn.m_85837_(0.001, 0.101, 0.001);
                    matrixStackIn.m_85841_(0.998f, 1.0f, 0.998f);
                }
                BakedModel model = this.m_110910_(state);
                if (SnowClientConfig.snowVariants && model instanceof SnowVariantModel && (snowVariant = ((SnowVariantModel)model).getSnowVariant()) != null) {
                    model = snowVariant;
                    useSnowVariant = true;
                }
                ret |= this.f_110900_.tesselateBlock(lightReaderIn, model, state, posIn, matrixStackIn, vertexBuilderIn, false, random, state.m_60726_(posIn), OverlayTexture.f_118083_, modelData);
                matrixStackIn.m_85849_();
            }
            if (options.renderBottom && (layer == null || layer == solid)) {
                if (ClientVariables.cachedSnowModel == null) {
                    ClientVariables.cachedSnowModel = this.m_110910_(CoreModule.BLOCK.defaultBlockState());
                }
                ret |= this.f_110900_.tesselateBlock(lightReaderIn, ClientVariables.cachedSnowModel, CoreModule.BLOCK.defaultBlockState(), posIn, matrixStackIn, vertexBuilderIn, false, random, state.m_60726_(posIn), OverlayTexture.f_118083_, modelData);
            }
            if (CoreModule.TILE_BLOCK.is(blockStateIn) || CoreModule.SLAB.is(blockStateIn)) {
                if (options.renderOverlay && layer == cutoutMipped) {
                    if (ClientVariables.cachedOverlayModel == null) {
                        ClientVariables.cachedOverlayModel = Minecraft.m_91087_().m_91304_().getModel(ClientVariables.OVERLAY_MODEL);
                    }
                    matrixStackIn.m_85836_();
                    BlockPos pos = posIn;
                    if (CoreModule.SLAB.is(blockStateIn)) {
                        matrixStackIn.m_85837_(0.0, -0.375, 0.0);
                    } else {
                        matrixStackIn.m_85837_(0.0, -1.0, 0.0);
                        pos = pos.m_7495_();
                    }
                    ret |= this.f_110900_.tesselateBlock(lightReaderIn, ClientVariables.cachedOverlayModel, blockStateIn, pos, matrixStackIn, vertexBuilderIn, false, random, blockStateIn.m_60726_(pos), OverlayTexture.f_118083_, modelData);
                    matrixStackIn.m_85849_();
                }
            } else if (!options.renderOverlay || useSnowVariant) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if (CoreModule.TILE_BLOCK.is(blockStateIn)) {
                if (layer != solid) {
                    ci.setReturnValue((Object)ret);
                    return;
                }
            } else if (layer != cutoutMipped) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if ((yOffset = ((SnowVariant)blockIn).getYOffset()) != 0.0) {
                matrixStackIn.m_85837_(0.0, yOffset, 0.0);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)lightReaderIn, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    @Shadow
    public abstract BakedModel m_110910_(BlockState var1);

    @Inject(at={@At(value="HEAD")}, method={"onResourceManagerReload"})
    private void srm_onResourceManagerReload(ResourceManager resourceManager, CallbackInfo ci) {
        ClientVariables.cachedSnowModel = null;
        ClientVariables.cachedOverlayModel = null;
    }
}

