/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.world.gen;

import com.zainjx.the_wild_update.entity.ModEntityTypes;
import com.zainjx.the_wild_update.world.biome.ModBiomes;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntityGeneration {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ResourceKey keySwamp = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)((Biome)ModBiomes.MANGROVE_SWAMP_BIOME.get()))));
        ResourceKey keySwampHills = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)((Biome)ModBiomes.MANGROVE_SWAMP_HILLS_BIOME.get()))));
        ModEntityGeneration.addEntityToSpecificBiomes(event, (EntityType)ModEntityTypes.FROG.get(), 40, 3, 7, Biomes.f_48207_, keySwampHills, keySwamp);
        ModEntityGeneration.addEntityToSpecificBiomes(event, (EntityType)ModEntityTypes.FROG.get(), 10, 1, 2, Biomes.f_48152_, Biomes.f_186761_, Biomes.f_186756_, Biomes.f_48203_, Biomes.f_48222_);
        ModEntityGeneration.addEntityToSpecificBiomes(event, (EntityType)ModEntityTypes.TADPOLE.get(), 20, 6, 19, Biomes.f_48207_);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomes(MobSpawnSettingsBuilder spawns, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = spawns.getSpawner(type.m_20674_());
        base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
    }
}

