/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import mca.block.TombstoneBlock;
import mca.util.localization.FlowingText;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TombstoneBlockEntityRenderer
implements BlockEntityRenderer<TombstoneBlock.Data> {
    private final Font text;

    public TombstoneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.text = context.m_173586_();
    }

    public void render(TombstoneBlock.Data entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!entity.hasEntity()) {
            return;
        }
        BlockState state = entity.m_58900_();
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        Direction facing = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
        matrices.m_85837_(0.0, 0.0, 0.0);
        matrices.m_85841_(0.010416667f, 0.010416667f, 0.010416667f);
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        TombstoneBlock block = (TombstoneBlock)state.m_60734_();
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(block.getRotation()));
        Vec3 offset = block.getNameplateOffset();
        matrices.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        int maxLineWidth = block.getLineWidth();
        float y = this.drawText(this.text, this.text.m_92923_((FormattedText)new TranslatableComponent("block.mca.tombstone.header"), maxLineWidth), 0.0f, matrices, vertexConsumers, light);
        y += 5.0f;
        FlowingText name = entity.getOrCreateEntityName(n -> FlowingText.Factory.wrapLines(this.text, n, maxLineWidth - 10, block.getMaxNameHeight()));
        matrices.m_85836_();
        matrices.m_85841_(name.scale(), name.scale(), name.scale());
        y = this.drawText(this.text, name.lines(), y / name.scale(), matrices, vertexConsumers, light) * name.scale();
        matrices.m_85849_();
        this.drawText(this.text, this.text.m_92923_((FormattedText)new TranslatableComponent("block.mca.tombstone.footer." + entity.getGender().binary().getStrName()), maxLineWidth), y += 5.0f, matrices, vertexConsumers, light);
        matrices.m_85849_();
    }

    private float drawText(Font text, List<FormattedCharSequence> lines, float y, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        for (FormattedCharSequence line : lines) {
            float x = (float)(-text.m_92724_(line)) / 2.0f;
            text.m_168645_(line, x, y, 0xFFFFFF, 0, matrices.m_85850_().m_85861_(), vertexConsumers, light);
            y += 10.0f;
        }
        return y;
    }
}

