/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import mca.Config;
import mca.entity.EntityWrapper;
import mca.entity.ai.DialogueType;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.resources.API;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface Messenger
extends EntityWrapper {
    public static final TargetingConditions CAN_RECEIVE = TargetingConditions.m_148353_();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(Player receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public TranslatableComponent getTranslatable(Player target, String phraseId, Object ... params) {
        String targetName;
        Level level = target.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            targetName = FamilyTree.get(world).getOrEmpty(target.m_142081_()).map(FamilyTreeNode::getName).filter(n -> !n.isEmpty()).orElse(target.m_7755_().getString());
        } else {
            targetName = target.m_7755_().getString();
        }
        return new TranslatableComponent(this.getDialogueType(target).name() + "." + phraseId, new Object[]{targetName, params});
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (Player player : this.asEntity().f_19853_.m_45955_(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().m_142469_().m_82400_(20.0))) {
            float dist = player.m_20270_((Entity)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).m_130940_(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatMessage(Player target, String phraseId, Object ... params) {
        this.sendChatMessage((MutableComponent)this.getTranslatable(target, phraseId, params), (Entity)target);
    }

    default public void sendChatMessage(MutableComponent message, Entity receiver) {
        if (this.isSpeechImpaired()) {
            message = new TranslatableComponent(API.getRandomSentence("zombie", message.getString()));
        } else if (this.isToYoungToSpeak()) {
            message = new TranslatableComponent(API.getRandomSentence("baby", message.getString()));
        }
        receiver.m_6352_((Component)new TextComponent(Config.getInstance().villagerChatPrefix).m_7220_(this.asEntity().m_5446_()).m_130946_(": ").m_7220_((Component)message), receiver.m_142081_());
        this.playSpeechEffect();
    }

    default public void sendEventMessage(Component message, Player receiver) {
        receiver.m_5661_(message, true);
    }

    default public void sendEventMessage(Component message) {
        if (!(this instanceof Entity)) {
            return;
        }
        Messenger.sendEventMessage(((Entity)this).f_19853_, message);
    }

    public static void sendEventMessage(Level world, Component message) {
        world.m_6907_().forEach(player -> player.m_5661_(message, true));
    }
}

