/*
 * Decompiled with CFR 0.152.
 */
package mca.network;

import java.util.Optional;
import mca.client.book.Book;
import mca.client.gui.BlueprintScreen;
import mca.client.gui.ExtendedBookScreen;
import mca.client.gui.FamilyTreeScreen;
import mca.client.gui.FamilyTreeSearchScreen;
import mca.client.gui.InteractScreen;
import mca.client.gui.NameBabyScreen;
import mca.client.gui.VillagerEditorScreen;
import mca.client.gui.WhistleScreen;
import mca.entity.VillagerLike;
import mca.item.BabyItem;
import mca.item.ExtendedWrittenBookItem;
import mca.network.ClientInteractionManager;
import mca.network.s2c.AnalysisResults;
import mca.network.s2c.BabyNameResponse;
import mca.network.s2c.FamilyTreeUUIDResponse;
import mca.network.s2c.GetChildDataResponse;
import mca.network.s2c.GetFamilyResponse;
import mca.network.s2c.GetFamilyTreeResponse;
import mca.network.s2c.GetInteractDataResponse;
import mca.network.s2c.GetVillageFailedResponse;
import mca.network.s2c.GetVillageResponse;
import mca.network.s2c.GetVillagerResponse;
import mca.network.s2c.InteractionDialogueResponse;
import mca.network.s2c.OpenGuiRequest;
import mca.network.s2c.ShowToastRequest;
import mca.network.s2c.VillagerNameResponse;
import mca.server.world.data.BabyTracker;
import mca.server.world.data.Village;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ClientInteractionManagerImpl
implements ClientInteractionManager {
    private final Minecraft client = Minecraft.m_91087_();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.f_91073_ != null);
        switch (message.gui) {
            case WHISTLE: {
                this.client.m_91152_((Screen)new WhistleScreen());
                break;
            }
            case BOOK: {
                ItemStack item;
                Item item2;
                if (this.client.f_91074_ == null || !((item2 = (item = this.client.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)item2;
                Book book = bookItem.getBook(item);
                this.client.m_91152_((Screen)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.m_91152_((Screen)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                VillagerLike villager = (VillagerLike)this.client.f_91073_.m_6815_(message.villager);
                this.client.m_91152_((Screen)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                Entity entity = this.client.f_91073_.m_6815_(message.villager);
                this.client.m_91152_((Screen)new VillagerEditorScreen(entity.m_142081_(), this.client.f_91074_.m_142081_()));
                break;
            }
            case BABY_NAME: {
                ItemStack item;
                if (this.client.f_91074_ == null || !((item = this.client.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof BabyItem)) break;
                this.client.m_91152_((Screen)new NameBabyScreen((Player)this.client.f_91074_, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.m_91152_((Screen)new FamilyTreeSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid, message.family);
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints);
            gui.setParents(message.father, message.mother);
            gui.setSpouse(message.marriageState, message.spouse);
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            Village village = new Village();
            village.load(message.getData());
            gui.setVillage(village);
            gui.setRank(message.rank, message.reputation, message.ids, message.tasks, message.buildingTypes);
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question, message.answers, message.silent);
        }
    }

    @Override
    public void handleChildData(GetChildDataResponse message) {
        BabyItem.CLIENT_STATE_CACHE.put((Object)message.id, Optional.ofNullable(message.getData()).map(BabyTracker.ChildSaveState::new));
    }

    @Override
    public void handleAnalysisResults(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis);
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.getName());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.getName());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        SystemToast.m_94855_((ToastComponent)this.client.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)message.getTitle(), (Component)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.getList());
        }
    }
}

