/*
 * Decompiled with CFR 0.152.
 */
package mca.network.c2s;

import java.util.Locale;
import java.util.Optional;
import mca.cobalt.network.Message;
import mca.server.world.data.Building;
import mca.server.world.data.GraveyardManager;
import mca.server.world.data.Village;
import mca.server.world.data.VillageManager;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(ServerPlayer player) {
        VillageManager villages = VillageManager.get(player.m_183503_());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.m_142538_(), true, this.action == Action.ADD_ROOM);
                player.m_5661_((Component)new TranslatableComponent("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH)), true);
                GraveyardManager.get(player.m_183503_()).reportToVillageManager((Entity)player);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(buildings -> buildings.getBuildings().values().stream().toList().forEach(b -> villages.processBuilding(b.getCenter(), true, false)));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((Entity)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((Vec3i)player.m_142538_())).findAny());
                if (building.isPresent()) {
                    if (this.action == Action.FORCE_TYPE) {
                        if (((Building)building.get()).getType().equals(this.data)) {
                            ((Building)building.get()).determineType();
                            break;
                        }
                        ((Building)building.get()).setForcedType(this.data);
                        break;
                    }
                    village.get().removeBuilding(((Building)building.get()).getId());
                    village.get().markDirty(player.m_183503_());
                    break;
                }
                player.m_5661_((Component)new TranslatableComponent("blueprint.noBuilding"), true);
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

