/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Map;
import mca.MCA;
import mca.entity.VillagerLike;
import mca.entity.ai.relationship.Gender;
import mca.resources.Resources;
import mca.resources.WeightedPool;
import mca.resources.data.Hair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class HairList
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("skins/hair");
    private final Map<Gender, WeightedPool.Mutable<Hair>> hair = new EnumMap<Gender, WeightedPool.Mutable<Hair>>(Gender.class);
    private static HairList INSTANCE;

    public static HairList getInstance() {
        return INSTANCE;
    }

    public HairList() {
        super(Resources.GSON, "skins/hair");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.hair.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.m_135815_().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            gender.getTransients().map(this::byGender).forEach(pool -> {
                int count = GsonHelper.m_13927_((JsonObject)file.getAsJsonObject(), (String)"count");
                float chance = GsonHelper.m_13820_((JsonObject)file.getAsJsonObject(), (String)"chance", (float)1.0f);
                for (int i = 0; i < count; ++i) {
                    pool.add(this.getHair(gender, i), chance);
                }
            });
        });
    }

    public WeightedPool.Mutable<Hair> byGender(Gender gender) {
        return this.hair.computeIfAbsent(gender, unused -> new WeightedPool.Mutable<Hair>(new Hair()));
    }

    private Hair getHair(Gender g, int i) {
        return new Hair(String.format("%s:skins/hair/%s/%d.png", "mca", g.getStrName(), i), String.format("%s:skins/hair/%s/%d_overlay.png", "mca", g.getStrName(), i));
    }

    public Hair pickOne(VillagerLike<?> villager) {
        return (Hair)this.hair.get((Object)villager.getGenetics().getGender()).pickOne();
    }

    public Hair pickNext(VillagerLike<?> villager, Hair current, int next) {
        return this.pickNext(villager.getGenetics().getGender(), current, next);
    }

    public Hair pickNext(Gender gender, Hair current, int next) {
        return this.hair.get((Object)gender).pickNext(current, next);
    }
}

