/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeyPanelBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class KeyPanelBlockEntity
extends CustomizableBlockEntity
implements IPasswordProtected,
ILockable {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            KeyPanelBlockEntity.this.f_58857_.m_46597_(KeyPanelBlockEntity.this.f_58858_, (BlockState)KeyPanelBlockEntity.this.m_58900_().m_61124_((Property)KeyPanelBlock.POWERED, (Comparable)((Boolean)this.get())));
            KeyPanelBlockEntity.this.f_58857_.m_46672_(KeyPanelBlockEntity.this.f_58858_, (Block)SCContent.KEY_PANEL_BLOCK.get());
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeyPanelBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);

    public KeyPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEY_PANEL_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength};
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeyPanelBlock) {
            KeyPanelBlock block2 = (KeyPanelBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (!this.f_58857_.f_46443_) {
            if (this.getPassword() != null) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSWORD, this.f_58858_));
            } else if (this.getOwner().isOwner(player)) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSWORD, this.f_58858_));
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        if (!((Boolean)state.m_61143_((Property)KeyPanelBlock.POWERED)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

