/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class UniversalOwnerChangerItem
extends Item {
    public UniversalOwnerChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), stack, ctx.m_43719_(), ctx.m_43724_());
    }

    public InteractionResult onItemUseFirst(Player player, Level level, BlockPos pos, ItemStack stack, Direction side, InteractionHand hand) {
        boolean isDefault;
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, stack).m_19089_();
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity be = level.m_7702_(pos);
        String newOwner = stack.m_41786_().getString();
        if (!(be instanceof IOwnable)) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.cantChange", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        IOwnable ownable = (IOwnable)be;
        Owner owner = ownable.getOwner();
        boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
        if (!owner.isOwner(player) && !isDefault) {
            DisguisableBlock db;
            Block block2;
            if (!(block instanceof IBlockMine || (block2 = be.m_58900_().m_60734_()) instanceof DisguisableBlock && !(((BlockItem)(db = (DisguisableBlock)block2).getDisguisedStack((BlockGetter)level, pos).m_41720_()).m_40614_() instanceof DisguisableBlock))) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.notOwned", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        if (!stack.m_41788_() && !isDefault) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        if (isDefault) {
            if (((Boolean)ConfigHandler.SERVER.allowBlockClaim.get()).booleanValue()) {
                newOwner = player.m_7755_().getString();
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noBlockClaiming", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        ownable.setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).m_142081_().toString() : "ownerUUID", newOwner);
        ownable.onOwnerChanged(state, level, pos, player);
        if (!level.f_46443_) {
            level.m_142572_().m_6846_().m_11268_(be.m_183216_());
        }
        if (FMLEnvironment.production && be instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)be;
            for (ModuleType moduleType : inv.getInsertedModules()) {
                ItemStack moduleStack = inv.getModule(moduleType);
                inv.removeModule(moduleType, false);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)moduleStack);
            }
        }
        PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack ownerChanger = player.m_21120_(hand);
        if (!ownerChanger.m_41788_()) {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.noName", new Object[0]), ChatFormatting.RED);
            return InteractionResultHolder.m_19100_((Object)ownerChanger);
        }
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            return this.handleBriefcase(player, ownerChanger);
        }
        return InteractionResultHolder.m_19098_((Object)ownerChanger);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, ItemStack ownerChanger) {
        ItemStack briefcase = player.m_21206_();
        if (BriefcaseItem.isOwnedBy(briefcase, player)) {
            String newOwner = ownerChanger.m_41786_().getString();
            if (!briefcase.m_41782_()) {
                briefcase.m_41751_(new CompoundTag());
            }
            briefcase.m_41783_().m_128359_("owner", newOwner);
            briefcase.m_41783_().m_128359_("ownerUUID", PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).m_142081_().toString() : "ownerUUID");
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
            return InteractionResultHolder.m_19090_((Object)ownerChanger);
        }
        PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
        return InteractionResultHolder.m_19096_((Object)ownerChanger);
    }
}

