/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public final class BlockEntityTracker<BE extends BlockEntity> {
    public static final BlockEntityTracker<SonicSecuritySystemBlockEntity> SONIC_SECURITY_SYSTEM = new BlockEntityTracker<SonicSecuritySystemBlockEntity>(be -> 30);
    public static final BlockEntityTracker<BlockChangeDetectorBlockEntity> BLOCK_CHANGE_DETECTOR = new BlockEntityTracker<BlockChangeDetectorBlockEntity>(be -> be.getRange());
    private final Map<ResourceKey<Level>, Collection<BlockPos>> trackedBlockEntities = new HashMap<ResourceKey<Level>, Collection<BlockPos>>();
    private final Function<BE, Integer> range;

    private BlockEntityTracker(Function<BE, Integer> range) {
        this.range = range;
    }

    public void track(BE be) {
        this.getTrackedBlockEntities(be.m_58904_()).add(be.m_58899_().m_7949_());
    }

    public void stopTracking(BE be) {
        this.getTrackedBlockEntities(be.m_58904_()).remove(be.m_58899_());
    }

    public List<BE> getBlockEntitiesInRange(Level level, BlockPos pos) {
        Collection<BlockPos> blockEntities = this.getTrackedBlockEntities(level);
        ArrayList<BlockEntity> returnValue = new ArrayList<BlockEntity>();
        Iterator<BlockPos> it = blockEntities.iterator();
        while (it.hasNext()) {
            BlockPos bePos = it.next();
            if (bePos != null) {
                try {
                    BlockEntity be = level.m_7702_(bePos);
                    if (be == null || !this.canReach(be, pos)) continue;
                    returnValue.add(be);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            it.remove();
        }
        return returnValue;
    }

    private Collection<BlockPos> getTrackedBlockEntities(Level level) {
        Collection<BlockPos> blockEntities = this.trackedBlockEntities.get(level.m_46472_());
        if (blockEntities == null) {
            blockEntities = new HashSet<BlockPos>();
            this.trackedBlockEntities.put((ResourceKey<Level>)level.m_46472_(), blockEntities);
        }
        return blockEntities;
    }

    public boolean canReach(BE be, BlockPos pos) {
        AABB range = new AABB(be.m_58899_()).m_82400_((double)this.range.apply(be).intValue());
        return range.f_82288_ <= (double)pos.m_123341_() && range.f_82289_ <= (double)pos.m_123342_() && range.f_82290_ <= (double)pos.m_123343_() && range.f_82291_ >= (double)pos.m_123341_() && range.f_82292_ >= (double)pos.m_123342_() && range.f_82293_ >= (double)pos.m_123343_();
    }
}

