/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class SetPassword {
    private String password;
    private int x;
    private int y;
    private int z;

    public SetPassword() {
    }

    public SetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public static void encode(SetPassword message, FriendlyByteBuf buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.m_130070_(message.password);
    }

    public static SetPassword decode(FriendlyByteBuf buf) {
        SetPassword message = new SetPassword();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.password = buf.m_130136_(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(SetPassword message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IOwnable ownable;
            IPasswordProtected be;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            String password = message.password;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            BlockEntity patt1752$temp = level.m_7702_(pos);
            if (patt1752$temp instanceof IPasswordProtected && (!((be = (IPasswordProtected)patt1752$temp) instanceof IOwnable) || (ownable = (IOwnable)((Object)be)).getOwner().isOwner((Player)player))) {
                be.setPassword(password);
                if (be instanceof KeypadChestBlockEntity) {
                    KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)be;
                    SetPassword.checkAndUpdateAdjacentChest(chestBe, level, pos, password, (Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void checkAndUpdateAdjacentChest(KeypadChestBlockEntity te, Level level, BlockPos pos, String codeToSet, Player player) {
        BlockPos offsetPos;
        BlockEntity otherBe;
        if (te.m_58900_().m_61143_((Property)KeypadChestBlock.f_51479_) != ChestType.SINGLE && (otherBe = level.m_7702_(offsetPos = pos.m_142300_(KeypadChestBlock.m_51584_((BlockState)te.m_58900_())))) instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)otherBe;
            if (te.getOwner().owns(chestBe)) {
                chestBe.setPassword(codeToSet);
                level.m_7260_(offsetPos, otherBe.m_58900_(), otherBe.m_58900_(), 2);
            }
        }
    }
}

