/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.formats.glyph.GlyphVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.ExtendedQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.QuadViewEntity;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.class_4608;
import org.lwjgl.system.MemoryUtil;

public class EntityVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements QuadVertexSink,
GlyphVertexSink {
    private static final int STRIDE = IrisVertexFormats.ENTITY.method_1362();
    private final QuadViewEntity.QuadViewEntityUnsafe quad = new QuadViewEntity.QuadViewEntityUnsafe();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;
    private float uSum;
    private float vSum;

    public EntityVertexBufferWriterUnsafe(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)ExtendedQuadVertexType.INSTANCE);
    }

    public void writeQuad(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3, int n4) {
        long l = this.writePointer;
        ++this.vertexCount;
        this.uSum += f4;
        this.vSum += f5;
        MemoryUtil.memPutFloat((long)l, (float)f);
        MemoryUtil.memPutFloat((long)(l + 4L), (float)f2);
        MemoryUtil.memPutFloat((long)(l + 8L), (float)f3);
        MemoryUtil.memPutInt((long)(l + 12L), (int)n);
        MemoryUtil.memPutFloat((long)(l + 16L), (float)f4);
        MemoryUtil.memPutFloat((long)(l + 20L), (float)f5);
        MemoryUtil.memPutInt((long)(l + 24L), (int)n3);
        MemoryUtil.memPutInt((long)(l + 28L), (int)n2);
        MemoryUtil.memPutShort((long)(l + 36L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity()));
        MemoryUtil.memPutShort((long)(l + 38L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity()));
        MemoryUtil.memPutShort((long)(l + 40L), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem()));
        if (this.vertexCount == 4) {
            this.endQuad(n4);
        }
        this.advance();
    }

    public void writeGlyph(float f, float f2, float f3, int n, float f4, float f5, int n2) {
        this.writeQuad(f, f2, f3, n, f4, f5, n2, class_4608.field_21444, 0);
    }

    private void endQuad(int n) {
        float f;
        float f2;
        float f3;
        this.vertexCount = 0;
        long l = this.writePointer;
        this.uSum = (float)((double)this.uSum * 0.25);
        this.vSum = (float)((double)this.vSum * 0.25);
        this.quad.setup(this.writePointer, STRIDE);
        if (n == 0) {
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            f3 = this.saveNormal.x;
            f2 = this.saveNormal.y;
            f = this.saveNormal.z;
            n = NormalHelper.packNormal(this.saveNormal, 0.0f);
        } else {
            f3 = Norm3b.unpackX((int)n);
            f2 = Norm3b.unpackY((int)n);
            f = Norm3b.unpackZ((int)n);
        }
        int n2 = NormalHelper.computeTangent(f3, f2, f, this.quad);
        for (long i = 0L; i < 4L; ++i) {
            MemoryUtil.memPutFloat((long)(l + 42L - (long)STRIDE * i), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(l + 46L - (long)STRIDE * i), (float)this.vSum);
            MemoryUtil.memPutInt((long)(l + 32L - (long)STRIDE * i), (int)n);
            MemoryUtil.memPutInt((long)(l + 50L - (long)STRIDE * i), (int)n2);
        }
        this.uSum = 0.0f;
        this.vSum = 0.0f;
    }
}

