/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.ScaleUtils;

public class CombinedScaleData
extends ScaleData {
    final Supplier<ScaleData[]> otherData;

    public CombinedScaleData(ScaleType scaleType, class_1297 entity, Supplier<ScaleData[]> otherData) {
        super(scaleType, entity);
        this.otherData = otherData;
    }

    protected ScaleData[] getData() {
        return this.otherData.get();
    }

    @Override
    public void tick() {
        super.tick();
        for (ScaleData d : this.getData()) {
            ScaleUtils.tickScale(d);
        }
    }

    @Override
    public void setBaseScale(float scale) {
        super.setBaseScale(scale);
        for (ScaleData d : this.getData()) {
            d.setBaseScale(scale);
        }
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        for (ScaleData d : this.getData()) {
            d.setScale(scale);
        }
    }

    @Override
    public void setTargetScale(float targetScale) {
        super.setTargetScale(targetScale);
        for (ScaleData d : this.getData()) {
            d.setTargetScale(targetScale);
        }
    }

    @Override
    public void setScaleTickDelay(int ticks) {
        super.setScaleTickDelay(ticks);
        for (ScaleData d : this.getData()) {
            d.setScaleTickDelay(ticks);
        }
    }

    @Override
    public void setPersistence(@Nullable Boolean persistent) {
        super.setPersistence(persistent);
        for (ScaleData d : this.getData()) {
            d.setPersistence(persistent);
        }
    }

    @Override
    public void markForSync(boolean sync) {
        super.markForSync(sync);
        for (ScaleData d : this.getData()) {
            d.markForSync(sync);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        for (ScaleData d : this.getData()) {
            d.onUpdate();
        }
    }

    @Override
    public ScaleData resetScale(boolean notifyListener) {
        ScaleData ret = super.resetScale(notifyListener);
        for (ScaleData d : this.getData()) {
            d.resetScale(notifyListener);
        }
        return ret;
    }

    @Override
    public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
        ScaleData ret = super.fromScale(scaleData, notifyListener);
        for (ScaleData d : this.getData()) {
            d.fromScale(scaleData, notifyListener);
        }
        return ret;
    }

    @Override
    public ScaleData averagedFromScales(ScaleData scaleData, ScaleData ... scales) {
        ScaleData ret = super.averagedFromScales(scaleData, scales);
        for (ScaleData d : this.getData()) {
            d.averagedFromScales(scaleData, scales);
        }
        return ret;
    }

    @Override
    public int hashCode() {
        return 31 * Arrays.hashCode(this.getData()) + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CombinedScaleData)) {
            return false;
        }
        return super.equals(obj) && Arrays.equals(this.getData(), ((CombinedScaleData)obj).getData());
    }
}

