/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import io.github.fabricators_of_create.porting_lib.block.CustomFrictionBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomLandingEffectsBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomRunningEffectsBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomSoundTypeBlock;
import io.github.fabricators_of_create.porting_lib.block.ExplosionResistanceBlock;
import io.github.fabricators_of_create.porting_lib.block.LightEmissiveBlock;
import io.github.fabricators_of_create.porting_lib.block.ValidSpawnBlock;
import io.github.fabricators_of_create.porting_lib.enchant.EnchantmentBonusBlock;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_322;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class CopycatBlock
extends class_2248
implements IBE<CopycatBlockEntity>,
IWrenchable,
CustomFrictionBlock,
CustomSoundTypeBlock,
LightEmissiveBlock,
ExplosionResistanceBlock,
BlockPickInteractionAware,
CustomLandingEffectsBlock,
CustomRunningEffectsBlock,
EnchantmentBonusBlock,
ValidSpawnBlock {
    public CopycatBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public <S extends class_2586> class_5558<S> method_31645(class_1937 p_153212_, class_2680 p_153213_, class_2591<S> p_153214_) {
        return null;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        this.onWrenched(state, context);
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return this.onBlockEntityUse((class_1922)context.method_8045(), context.method_8037(), ufte -> {
            class_1799 consumedItem = ufte.getConsumedItem();
            if (!ufte.hasCustomMaterial()) {
                return class_1269.field_5811;
            }
            class_1657 player = context.method_8036();
            if (!player.method_7337()) {
                player.method_31548().method_7398(consumedItem);
            }
            context.method_8045().method_20290(2001, context.method_8037(), class_2248.method_9507((class_2680)ufte.method_11010()));
            ufte.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
            ufte.setConsumedItem(class_1799.field_8037);
            return class_1269.field_5812;
        });
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (pPlayer == null) {
            return class_1269.field_5811;
        }
        class_2350 face = pHit.method_17780();
        class_1799 itemInHand = pPlayer.method_5998(pHand);
        class_2680 materialIn = this.getAcceptedBlockState(pLevel, pPos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(pLevel, pPos, pState, pPlayer, pHand, pHit, materialIn);
        }
        if (materialIn == null) {
            return class_1269.field_5811;
        }
        class_2680 material = materialIn;
        return this.onBlockEntityUse((class_1922)pLevel, pPos, ufte -> {
            if (ufte.getMaterial().method_27852(material.method_26204())) {
                if (!ufte.cycleMaterial()) {
                    return class_1269.field_5811;
                }
                ufte.method_10997().method_8396(null, ufte.method_11016(), class_3417.field_14667, class_3419.field_15245, 0.75f, 0.95f);
                return class_1269.field_5812;
            }
            if (ufte.hasCustomMaterial()) {
                return class_1269.field_5811;
            }
            if (pLevel.method_8608()) {
                return class_1269.field_5812;
            }
            ufte.setMaterial(material);
            ufte.setConsumedItem(itemInHand);
            ufte.method_10997().method_8396(null, ufte.method_11016(), material.method_26231().method_10598(), class_3419.field_15245, 1.0f, 0.75f);
            if (pPlayer.method_7337()) {
                return class_1269.field_5812;
            }
            itemInHand.method_7934(1);
            if (itemInHand.method_7960()) {
                pPlayer.method_6122(pHand, class_1799.field_8037);
            }
            return class_1269.field_5812;
        });
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        if (pPlacer == null) {
            return;
        }
        class_1799 offhandItem = pPlacer.method_5998(class_1268.field_5810);
        class_2680 appliedState = this.getAcceptedBlockState(pLevel, pPos, offhandItem, class_2350.method_10159((class_1297)pPlacer)[0]);
        if (appliedState == null) {
            return;
        }
        this.withBlockEntityDo((class_1922)pLevel, pPos, ufte -> {
            class_1657 player;
            if (ufte.hasCustomMaterial()) {
                return;
            }
            ufte.setMaterial(appliedState);
            ufte.setConsumedItem(offhandItem);
            if (pPlacer instanceof class_1657 && (player = (class_1657)pPlacer).method_7337()) {
                return;
            }
            offhandItem.method_7934(1);
            if (offhandItem.method_7960()) {
                pPlacer.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
        });
    }

    @Nullable
    public class_2680 getAcceptedBlockState(class_1937 pLevel, class_2338 pPos, class_1799 item, class_2350 face) {
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return null;
        }
        class_1747 bi = (class_1747)class_17922;
        class_2248 block = bi.method_7711();
        if (block instanceof CopycatBlock) {
            return null;
        }
        class_2680 appliedState = block.method_9564();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof class_2343) {
                return null;
            }
            if (block instanceof class_2510) {
                return null;
            }
            if (pLevel != null) {
                class_265 shape = appliedState.method_26218((class_1922)pLevel, pPos);
                if (shape.method_1110() || !shape.method_1107().equals((Object)class_259.method_1077().method_1107())) {
                    return null;
                }
                class_265 collisionShape = appliedState.method_26220((class_1922)pLevel, pPos);
                if (collisionShape.method_1110()) {
                    return null;
                }
            }
        }
        if (face != null) {
            class_2350.class_2351 axis = face.method_10166();
            if (appliedState.method_28498((class_2769)class_2741.field_12525)) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12525, (Comparable)face);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12481) && axis != class_2350.class_2351.field_11052) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12481, (Comparable)face);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12496)) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12529) && axis != class_2350.class_2351.field_11052) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12529, (Comparable)axis);
            }
        }
        return appliedState;
    }

    public boolean isAcceptedRegardless(class_2680 material) {
        return false;
    }

    public class_2680 prepareMaterial(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer, class_1268 pHand, class_3965 pHit, class_2680 material) {
        return material;
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        if (!pState.method_31709() || pState.method_26204() == pNewState.method_26204()) {
            return;
        }
        if (!pIsMoving) {
            this.withBlockEntityDo((class_1922)pLevel, pPos, ufte -> class_2248.method_9577((class_1937)pLevel, (class_2338)pPos, (class_1799)ufte.getConsumedItem()));
        }
        pLevel.method_8544(pPos);
    }

    public void method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pPlayer.method_7337()) {
            this.withBlockEntityDo((class_1922)pLevel, pPos, ufte -> ufte.setConsumedItem(class_1799.field_8037));
        }
    }

    @Override
    public Class<CopycatBlockEntity> getBlockEntityClass() {
        return CopycatBlockEntity.class;
    }

    @Override
    public class_2591<? extends CopycatBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.COPYCAT.get();
    }

    @Environment(value=EnvType.CLIENT)
    public class_2680 getAppearance(class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 queryState, class_2338 queryPos) {
        if (this.isIgnoredConnectivitySide(level, state, side, pos, queryPos)) {
            return state;
        }
        return CopycatModel.getMaterial(CopycatBlock.getMaterial((class_1922)level, pos));
    }

    public boolean isIgnoredConnectivitySide(class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        return false;
    }

    public abstract boolean canConnectTexturesToward(class_1920 var1, class_2338 var2, class_2338 var3, class_2680 var4);

    public static class_2680 getMaterial(class_1922 reader, class_2338 targetPos) {
        class_2586 class_25862 = reader.method_8321(targetPos);
        if (class_25862 instanceof CopycatBlockEntity) {
            CopycatBlockEntity cbe = (CopycatBlockEntity)class_25862;
            return cbe.getMaterial();
        }
        return class_2246.field_10124.method_9564();
    }

    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        return false;
    }

    public boolean shouldFaceAlwaysRender(class_2680 state, class_2350 face) {
        return false;
    }

    public class_2498 getSoundType(class_2680 state, class_4538 level, class_2338 pos, class_1297 entity) {
        return CopycatBlock.getMaterial((class_1922)level, pos).method_26231();
    }

    public float getFriction(class_2680 state, class_4538 level, class_2338 pos, class_1297 entity) {
        return CopycatBlock.maybeMaterialAs((class_1922)level, pos, CustomFrictionBlock.class, (material, block) -> Float.valueOf(block.getFriction(material, level, pos, entity)), material -> Float.valueOf(material.method_26204().method_9499())).floatValue();
    }

    public int getLightEmission(class_2680 state, class_1922 level, class_2338 pos) {
        return CopycatBlock.maybeMaterialAs(level, pos, LightEmissiveBlock.class, (material, block) -> block.getLightEmission(material, level, pos), class_4970.class_4971::method_26213);
    }

    public float getExplosionResistance(class_2680 state, class_1922 level, class_2338 pos, class_1927 explosion) {
        return CopycatBlock.maybeMaterialAs(level, pos, ExplosionResistanceBlock.class, (material, block) -> Float.valueOf(block.getExplosionResistance(material, level, pos, explosion)), material -> Float.valueOf(material.method_26204().method_9520())).floatValue();
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_1657 player, @Nullable class_239 result) {
        class_2680 material = CopycatBlock.getMaterial(level, pos);
        if (AllBlocks.COPYCAT_BASE.has(material) || player != null && player.method_21749()) {
            return new class_1799((class_1935)this);
        }
        return CopycatBlock.maybeMaterialAs(level, pos, BlockPickInteractionAware.class, (mat, block) -> block.getPickedStack(mat, level, pos, player, result), mat -> mat.method_26204().method_9574(level, pos, mat));
    }

    public boolean addLandingEffects(class_2680 state1, class_3218 level, class_2338 pos, class_2680 state2, class_1309 entity, int numberOfParticles) {
        return CopycatBlock.maybeMaterialAs((class_1922)level, pos, CustomLandingEffectsBlock.class, (material, block) -> block.addLandingEffects(material, level, pos, material, entity, numberOfParticles), material -> false);
    }

    public boolean addRunningEffects(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        return CopycatBlock.maybeMaterialAs((class_1922)level, pos, CustomRunningEffectsBlock.class, (material, block) -> block.addRunningEffects(material, level, pos, entity), material -> false);
    }

    public float getEnchantPowerBonus(class_2680 state, class_4538 level, class_2338 pos) {
        return CopycatBlock.maybeMaterialAs((class_1922)level, pos, EnchantmentBonusBlock.class, (material, block) -> Float.valueOf(block.getEnchantPowerBonus(material, level, pos)), material -> Float.valueOf(super.getEnchantPowerBonus(material, level, pos))).floatValue();
    }

    public boolean isValidSpawn(class_2680 state, class_1922 level, class_2338 pos, class_1317.class_1319 type, class_1299<?> entityType) {
        return false;
    }

    public void method_9554(class_1937 pLevel, class_2680 pState, class_2338 pPos, class_1297 pEntity, float p_152430_) {
        class_2680 material = CopycatBlock.getMaterial((class_1922)pLevel, pPos);
        material.method_26204().method_9554(pLevel, material, pPos, pEntity, p_152430_);
    }

    public float method_9594(class_2680 pState, class_1657 pPlayer, class_1922 pLevel, class_2338 pPos) {
        return CopycatBlock.getMaterial(pLevel, pPos).method_26165(pPlayer, pLevel, pPos);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_322 wrappedColor() {
        return new WrappedBlockColor();
    }

    private static <T, R> R maybeMaterialAs(class_1922 level, class_2338 pos, Class<T> clazz, BiFunction<class_2680, T, R> ifType, Function<class_2680, R> ifNot) {
        class_2680 material = CopycatBlock.getMaterial(level, pos);
        class_2248 block = material.method_26204();
        if (clazz.isInstance(block)) {
            return ifType.apply(material, (class_2680)clazz.cast(block));
        }
        return ifNot.apply(material);
    }

    @Environment(value=EnvType.CLIENT)
    public static class WrappedBlockColor
    implements class_322 {
        public int getColor(class_2680 pState, @Nullable class_1920 pLevel, @Nullable class_2338 pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return class_1933.method_8377((double)0.5, (double)1.0);
            }
            return class_310.method_1551().method_1505().method_1697(CopycatBlock.getMaterial((class_1922)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

