/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.fabric.model.CullingBakedModel;
import com.jozufozu.flywheel.fabric.model.FabricModelUtil;
import com.jozufozu.flywheel.fabric.model.LayerFilteringBakedModel;
import com.jozufozu.flywheel.util.Pair;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<class_1921, SuperByteBuffer> bufferCache = new LinkedHashMap<class_1921, SuperByteBuffer>();
    private boolean active;
    private boolean changed = false;
    protected SchematicWorld schematic;
    private class_2338 anchor;

    public void display(SchematicWorld world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null || !this.changed) {
            return;
        }
        this.redraw();
        this.changed = false;
    }

    public void render(class_4587 ms, SuperRenderTypeBuffer buffers) {
        if (!this.active) {
            return;
        }
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms, buffers.getBuffer((class_1921)layer)));
        BlockEntityRenderHelper.renderBlockEntities(this.schematic, this.schematic.getRenderedBlockEntities(), ms, buffers);
    }

    protected void redraw() {
        this.bufferCache.clear();
        for (class_1921 layer : class_1921.method_22720()) {
            SuperByteBuffer buffer = this.drawLayer(layer);
            if (buffer.isEmpty()) continue;
            this.bufferCache.put(layer, buffer);
        }
    }

    protected SuperByteBuffer drawLayer(class_1921 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        class_2338.class_2339 mutableBlockPos = objects.mutableBlockPos;
        SchematicWorld renderWorld = this.schematic;
        renderWorld.renderMode = true;
        class_3341 bounds = renderWorld.getBounds();
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        class_287 builder = new class_287(512);
        class_287 unshadedBuilder = objects.unshadedBuilder;
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        unshadedBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        shadeSeparatingWrapper.prepare((class_4588)builder, (class_4588)unshadedBuilder);
        class_778.method_20544();
        for (class_2338 localPos : class_2338.method_10094((int)bounds.method_35415(), (int)bounds.method_35416(), (int)bounds.method_35417(), (int)bounds.method_35418(), (int)bounds.method_35419(), (int)bounds.method_35420())) {
            class_2338.class_2339 pos = mutableBlockPos.method_35831((class_2382)localPos, (class_2382)this.anchor);
            class_2680 state = renderWorld.method_8320((class_2338)pos);
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = dispatcher.method_3349(state);
            long seed = state.method_26190((class_2338)pos);
            random.method_43052(seed);
            if (((FabricBakedModel)model).isVanillaAdapter()) {
                if (!FabricModelUtil.doesLayerMatch((class_2680)state, (class_1921)layer)) {
                    continue;
                }
            } else {
                model = CullingBakedModel.wrap((class_1087)model);
                model = LayerFilteringBakedModel.wrap((class_1087)model, (class_1921)layer);
            }
            model = shadeSeparatingWrapper.wrapModel(model);
            poseStack.method_22903();
            poseStack.method_22904((double)localPos.method_10263(), (double)localPos.method_10264(), (double)localPos.method_10260());
            renderer.method_3374((class_1920)renderWorld, model, state, (class_2338)pos, poseStack, (class_4588)shadeSeparatingWrapper, true, random, seed, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        shadeSeparatingWrapper.clear();
        Pair pair = ModelUtil.endShadeSeparated((class_287)builder, (class_287)unshadedBuilder);
        renderWorld.renderMode = false;
        return new SuperByteBuffer((class_287.class_7433)pair.first(), (Integer)pair.second());
    }

    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final class_287 unshadedBuilder = new class_287(512);

        private ThreadLocalObjects() {
        }
    }
}

