/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.FabricPonderProcessing;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderChapterRegistry;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import com.simibubi.create.infrastructure.ponder.SharedText;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;

public class PonderRegistry {
    public static final PonderTagRegistry TAGS = new PonderTagRegistry();
    public static final PonderChapterRegistry CHAPTERS = new PonderChapterRegistry();
    public static final Map<class_2960, List<PonderStoryBoardEntry>> ALL = new HashMap<class_2960, List<PonderStoryBoardEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStoryBoard(PonderStoryBoardEntry entry) {
        Map<class_2960, List<PonderStoryBoardEntry>> map = ALL;
        synchronized (map) {
            List list;
            List list2 = list = ALL.computeIfAbsent(entry.getComponent(), $ -> new ArrayList());
            synchronized (list2) {
                list.add(entry);
            }
        }
    }

    public static List<PonderScene> compile(class_2960 id) {
        List<PonderStoryBoardEntry> list = ALL.get(id);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(PonderChapter chapter) {
        List<PonderStoryBoardEntry> list = CHAPTERS.getStories(chapter);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(List<PonderStoryBoardEntry> entries) {
        if (PonderIndex.editingModeActive()) {
            PonderLocalization.SHARED.clear();
            SharedText.gatherText();
        }
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (int i = 0; i < entries.size(); ++i) {
            PonderStoryBoardEntry sb = entries.get(i);
            class_2960 id = sb.getSchematicLocation();
            class_3499 activeTemplate = PonderRegistry.loadSchematic(id);
            class_1937 level = (class_1937)EnvExecutor.unsafeRunForDist(() -> () -> class_310.method_1551().field_1687, () -> () -> {
                throw new IllegalStateException("Cannot compile on a server");
            });
            PonderWorld world = new PonderWorld(class_2338.field_10980, level);
            class_3492 settings = FabricPonderProcessing.makePlaceSettings(id);
            activeTemplate.method_15172((class_5425)world, class_2338.field_10980, class_2338.field_10980, settings, world.field_9229, 2);
            world.createBackup();
            PonderScene scene = PonderRegistry.compileScene(i, sb, world);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(int i, PonderStoryBoardEntry sb, PonderWorld world) {
        PonderScene scene = new PonderScene(world, sb.getNamespace(), sb.getComponent(), sb.getTags());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static class_3499 loadSchematic(class_2960 location) {
        return PonderRegistry.loadSchematic(class_310.method_1551().method_1478(), location);
    }

    public static class_3499 loadSchematic(class_3300 resourceManager, class_2960 location) {
        String path;
        String namespace = location.method_12836();
        class_2960 location1 = new class_2960(namespace, path = "ponder/" + location.method_12832() + ".nbt");
        Optional optionalResource = resourceManager.method_14486(location1);
        if (optionalResource.isPresent()) {
            class_3499 class_34992;
            block10: {
                class_3298 resource = (class_3298)optionalResource.get();
                InputStream inputStream = resource.method_14482();
                try {
                    class_34992 = PonderRegistry.loadSchematic(inputStream);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Create.LOGGER.error("Failed to read ponder schematic: " + location1, (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return class_34992;
        } else {
            Create.LOGGER.error("Ponder schematic missing: " + location1);
        }
        return new class_3499();
    }

    public static class_3499 loadSchematic(InputStream resourceStream) throws IOException {
        class_3499 t = new class_3499();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        class_2487 nbt = class_2507.method_10625((DataInput)stream, (class_2505)new class_2505(0x20000000L));
        t.method_15183(nbt);
        return t;
    }
}

