/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.gameplay.trackers;

import net.minecraft.class_1091;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.api.VRData;
import org.vivecraft.gameplay.trackers.Tracker;
import org.vivecraft.render.RenderPass;
import org.vivecraft.utils.Utils;
import org.vivecraft.utils.math.Matrix4f;
import org.vivecraft.utils.math.Quaternion;
import org.vivecraft.utils.math.Vector3;

public class CameraTracker
extends Tracker {
    public static final class_1091 cameraModel = new class_1091("vivecraft:camera");
    public static final class_1091 cameraDisplayModel = new class_1091("vivecraft:camera_display");
    private boolean visible = false;
    private class_243 position = new class_243(0.0, 0.0, 0.0);
    private Quaternion rotation = new Quaternion();
    private int startController;
    private VRData.VRDevicePose startControllerPose;
    private class_243 startPosition;
    private Quaternion startRotation;
    private boolean quickMode;

    public CameraTracker(class_310 mc, ClientDataHolder dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return this.isVisible();
    }

    @Override
    public void doProcess(class_746 player) {
        if (this.startControllerPose != null) {
            VRData.VRDevicePose vrdata$vrdevicepose = this.dh.vrPlayer.vrdata_world_render.getController(this.startController);
            class_243 vec3 = this.startControllerPose.getPosition();
            class_243 vec31 = vrdata$vrdevicepose.getPosition().method_1020(vec3);
            Matrix4f matrix4f = Matrix4f.multiply(vrdata$vrdevicepose.getMatrix(), this.startControllerPose.getMatrix().inverted());
            Vector3 vector3 = new Vector3((float)this.startPosition.field_1352 - (float)vec3.field_1352, (float)this.startPosition.field_1351 - (float)vec3.field_1351, (float)this.startPosition.field_1350 - (float)vec3.field_1350);
            Vector3 vector31 = matrix4f.transform(vector3);
            this.position = new class_243(this.startPosition.field_1352 + (double)((float)vec31.field_1352) + (double)(vector31.getX() - vector3.getX()), this.startPosition.field_1351 + (double)((float)vec31.field_1351) + (double)(vector31.getY() - vector3.getY()), this.startPosition.field_1350 + (double)((float)vec31.field_1350) + (double)(vector31.getZ() - vector3.getZ()));
            this.rotation = this.startRotation.multiply(new Quaternion(Utils.convertOVRMatrix(matrix4f)));
        }
        if (this.quickMode && !this.isMoving() && !this.dh.grabScreenShot) {
            this.visible = false;
        }
        if (this.dh.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition().method_1022(this.position) > (double)(this.mc.field_1690.method_38521() * 12)) {
            this.visible = false;
        }
    }

    @Override
    public void reset(class_746 player) {
        this.visible = false;
        this.quickMode = false;
        this.stopMoving();
    }

    @Override
    public Tracker.EntryPoint getEntryPoint() {
        return Tracker.EntryPoint.SPECIAL_ITEMS;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public void setPosition(class_243 position) {
        this.position = position;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
    }

    public boolean isMoving() {
        return this.startControllerPose != null;
    }

    public int getMovingController() {
        return this.startController;
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public void startMoving(int controller, boolean quickMode) {
        this.startController = controller;
        this.startControllerPose = this.dh.vrPlayer.vrdata_world_pre.getController(controller);
        this.startPosition = this.position;
        this.startRotation = this.rotation.copy();
        this.quickMode = quickMode;
    }

    public void startMoving(int controller) {
        this.startMoving(controller, false);
    }

    public void stopMoving() {
        this.startControllerPose = null;
    }
}

