/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.gameplay.trackers;

import net.minecraft.class_1690;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.gameplay.VRPlayer;
import org.vivecraft.gameplay.trackers.Tracker;
import org.vivecraft.settings.VRSettings;
import org.vivecraft.utils.math.Quaternion;

public class RowTracker
extends Tracker {
    class_243[] lastUWPs = new class_243[2];
    public double[] forces = new double[]{0.0, 0.0};
    double transmissionEfficiency = 0.9;
    public float LOar;
    public float ROar;
    public float Foar;

    public RowTracker(class_310 mc, ClientDataHolder dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(class_746 p) {
        if (ClientDataHolder.getInstance().vrSettings.seated) {
            return false;
        }
        if (!ClientDataHolder.getInstance().vrSettings.realisticRowEnabled) {
            return false;
        }
        if (p != null && p.method_5805()) {
            if (this.mc.field_1761 == null) {
                return false;
            }
            if (class_310.method_1551().field_1690.field_1894.method_1434()) {
                return false;
            }
            if (!(p.method_5854() instanceof class_1690)) {
                return false;
            }
            return !ClientDataHolder.getInstance().bowTracker.isNotched();
        }
        return false;
    }

    public boolean isRowing() {
        return this.ROar + this.LOar + this.Foar > 0.0f;
    }

    @Override
    public void reset(class_746 player) {
        this.LOar = 0.0f;
        this.ROar = 0.0f;
        this.Foar = 0.0f;
    }

    @Override
    public void doProcess(class_746 player) {
        double d0 = this.dh.vr.controllerHistory[0].averageSpeed(0.5);
        double d1 = this.dh.vr.controllerHistory[1].averageSpeed(0.5);
        float f = 0.5f;
        float f1 = 2.0f;
        this.ROar = (float)Math.max(d0 - (double)f, 0.0);
        this.LOar = (float)Math.max(d1 - (double)f, 0.0);
        float f2 = this.Foar = this.ROar > 0.0f && this.LOar > 0.0f ? (this.ROar + this.LOar) / 2.0f : 0.0f;
        if (this.Foar > f1) {
            this.Foar = f1;
        }
        if (this.ROar > f1) {
            this.ROar = f1;
        }
        if (this.LOar > f1) {
            this.LOar = f1;
        }
    }

    public void doProcessFinaltransmithastofixthis(class_746 player) {
        class_1690 boat = (class_1690)player.method_5854();
        Quaternion quaternion = new Quaternion(boat.method_36455(), -(boat.method_36454() % 360.0f), 0.0f).normalized();
        for (int i = 0; i <= 1; ++i) {
            if (!this.isPaddleUnderWater(i, boat)) {
                this.forces[i] = 0.0;
                this.lastUWPs[i] = null;
                continue;
            }
            class_243 vec3 = this.getArmToPaddleVector(i, boat);
            class_243 vec31 = this.getAttachmentPoint(i, boat);
            class_243 vec32 = vec31.method_1019(vec3.method_1029()).method_1020(boat.method_19538());
            if (this.lastUWPs[i] != null) {
                class_243 vec34;
                class_243 vec33 = this.lastUWPs[i].method_1020(vec32);
                double d0 = (vec33 = vec33.method_1020(boat.method_18798())).method_1026(vec34 = quaternion.multiply(new class_243(0.0, 0.0, 1.0))) * this.transmissionEfficiency / 5.0;
                this.forces[i] = !(d0 < 0.0 && this.forces[i] > 0.0 || d0 > 0.0 && this.forces[i] < 0.0) ? Math.min(Math.max(d0, -0.1), 0.1) : 0.0;
            }
            this.lastUWPs[i] = vec32;
        }
    }

    class_243 getArmToPaddleVector(int paddle, class_1690 boat) {
        class_243 vec3 = this.getAttachmentPoint(paddle, boat);
        class_243 vec31 = this.getAbsArmPos(paddle == 0 ? 1 : 0);
        return vec3.method_1020(vec31);
    }

    class_243 getAttachmentPoint(int paddle, class_1690 boat) {
        class_243 vec3 = new class_243((double)((paddle == 0 ? 9.0f : -9.0f) / 16.0f), 0.625, 0.1875);
        Quaternion quaternion = new Quaternion(boat.method_36455(), -(boat.method_36454() % 360.0f), 0.0f).normalized();
        return boat.method_19538().method_1019(quaternion.multiply(vec3));
    }

    class_243 getAbsArmPos(int side) {
        class_243 vec3 = this.dh.vr.controllerHistory[side].averagePosition(0.1);
        Quaternion quaternion = new Quaternion(0.0f, VRSettings.inst.worldRotation, 0.0f);
        return VRPlayer.get().roomOrigin.method_1019(quaternion.multiply(vec3));
    }

    boolean isPaddleUnderWater(int paddle, class_1690 boat) {
        class_243 vec3 = this.getAttachmentPoint(paddle, boat);
        class_243 vec31 = this.getArmToPaddleVector(paddle, boat).method_1029();
        class_2338 blockpos = new class_2338(vec3.method_1019(vec31));
        return boat.field_6002.method_8320(blockpos).method_26207().method_15797();
    }
}

