/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.render.ik;

import org.vivecraft.render.ik.IKInfo;

public class IKHelper {
    public static IKInfo CalcIK_2D_TwoBoneAnalytic(boolean solvePosAngle2, double length1, double length2, double targetX, double targetY) {
        double d2;
        double d8;
        double d0 = 1.0E-4;
        IKInfo ikinfo = new IKInfo();
        ikinfo.foundValidSolution = true;
        double d1 = targetX * targetX + targetY * targetY;
        double d3 = 2.0 * length1 * length2;
        if (d3 > 1.0E-4) {
            d8 = (d1 - length1 * length1 - length2 * length2) / d3;
            if (d8 < -1.0 || d8 > 1.0) {
                ikinfo.foundValidSolution = false;
            }
            d8 = Math.max(-1.0, Math.min(1.0, d8));
            ikinfo.angle2 = Math.acos(d8);
            if (!solvePosAngle2) {
                ikinfo.angle2 = -ikinfo.angle2;
            }
            d2 = Math.sin(ikinfo.angle2);
        } else {
            double d4 = (length1 + length2) * (length1 + length2);
            if (d1 < d4 - 1.0E-4 || d1 > d4 + 1.0E-4) {
                ikinfo.foundValidSolution = false;
            }
            ikinfo.angle2 = 0.0;
            d8 = 1.0;
            d2 = 0.0;
        }
        double d9 = length1 + length2 * d8;
        double d5 = length2 * d2;
        double d6 = targetY * d9 - targetX * d5;
        double d7 = targetX * d9 + targetY * d5;
        ikinfo.angle1 = Math.atan2(d6, d7);
        return ikinfo;
    }
}

