/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.settings.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ProfileManager {
    public static final String DEFAULT_PROFILE = "Default";
    public static final String PROFILE_SET_OF = "Of";
    public static final String PROFILE_SET_MC = "Mc";
    public static final String PROFILE_SET_VR = "Vr";
    public static final String PROFILE_SET_CONTROLLER_BINDINGS = "Controller";
    static final String KEY_PROFILES = "Profiles";
    static final String KEY_SELECTED_PROFILE = "selectedProfile";
    static String currentProfileName = "Default";
    static File vrProfileCfgFile = null;
    static JsonObject jsonConfigRoot = null;
    static JsonObject profiles = null;
    static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    static boolean loaded = false;
    public static final String[] DEFAULT_BINDINGS = new String[]{"key.playerlist:b:6:Button 6", "axis.updown:a:2:-:Y Rotation", "walk.forward:a:0:-:Y ", "gui.axis.leftright:a:3:-:X Rotation", "gui.axis.updown:a:2:-:Y Rotation", "key.sneak:b:9:Button 9", "gui.Left:px:-", "key.itemright:b:5:Button 5", "gui.Right:px:+", "key.left:a:1:-:X ", "gui.Select:b:0:Button 0", "key.aimcenter:b:8:Button 8", "key.pickItem:b:2:Button 2", "key.menu:b:7:Button 7", "key.attack:a:4:-:Z ", "gui.Up:py:-", "key.use:a:4:+:Z ", "axis.leftright:a:3:-:X Rotation", "gui.Down:py:+", "key.right:a:1:+:X ", "key.back:a:0:+:Y ", "key.inventory:b:3:Button 3", "key.jump:b:0:Button 0", "key.drop:b:1:Button 1", "gui.Back:b:1:Button 1", "key.itemleft:b:4:Button 4"};

    public static synchronized void init(File dataDir) {
        vrProfileCfgFile = new File(dataDir, "optionsviveprofiles.txt");
        ProfileManager.load();
    }

    public static synchronized void load() {
        try {
            if (!vrProfileCfgFile.exists()) {
                vrProfileCfgFile.createNewFile();
            }
            InputStreamReader inputstreamreader = new InputStreamReader((InputStream)new FileInputStream(vrProfileCfgFile), "UTF-8");
            try {
                jsonConfigRoot = JsonParser.parseReader((Reader)inputstreamreader).getAsJsonObject();
            }
            catch (Exception exception) {
                jsonConfigRoot = new JsonObject();
            }
            inputstreamreader.close();
            if (jsonConfigRoot.has(KEY_SELECTED_PROFILE)) {
                currentProfileName = jsonConfigRoot.get(KEY_SELECTED_PROFILE).getAsString();
            } else {
                jsonConfigRoot.add(KEY_SELECTED_PROFILE, (JsonElement)new JsonPrimitive(DEFAULT_PROFILE));
            }
            if (jsonConfigRoot.has(KEY_PROFILES)) {
                profiles = jsonConfigRoot.get(KEY_PROFILES).getAsJsonObject();
            } else {
                profiles = new JsonObject();
                jsonConfigRoot.add(KEY_PROFILES, (JsonElement)profiles);
            }
            if (!profiles.has(DEFAULT_PROFILE)) {
                JsonObject JsonObject2 = new JsonObject();
                profiles.add(DEFAULT_PROFILE, (JsonElement)JsonObject2);
            }
            ProfileManager.validateProfiles();
            loaded = true;
        }
        catch (Exception exception1) {
            System.out.println("FAILED to read VR profile settings!");
            exception1.printStackTrace();
            loaded = false;
        }
    }

    private static void validateProfiles() throws Exception {
        for (Object object : profiles.keySet()) {
            String s = (String)object;
            JsonElement object1 = profiles.get(s);
            if (!(object1 instanceof JsonObject)) continue;
            JsonObject JsonObject2 = (JsonObject)object1;
            JsonObject JsonObject1 = null;
            JsonObject JsonObject22 = null;
            JsonObject JsonObject3 = null;
            JsonObject JsonObject4 = null;
            for (Object object2 : JsonObject2.keySet()) {
                String s1 = (String)object2;
                JsonElement object3 = JsonObject2.get(s1);
                if (!(object3 instanceof JsonObject)) continue;
                if (s1.equals(PROFILE_SET_MC)) {
                    JsonObject1 = (JsonObject)object3;
                }
                if (s1.equals(PROFILE_SET_OF)) {
                    JsonObject22 = (JsonObject)object3;
                }
                if (s1.equals(PROFILE_SET_VR)) {
                    JsonObject3 = (JsonObject)object3;
                }
                if (!s1.equals(PROFILE_SET_CONTROLLER_BINDINGS)) continue;
                JsonObject4 = (JsonObject)object3;
            }
        }
    }

    private static synchronized boolean loadLegacySettings(File settingsFile, JsonObject theProfile, String set) throws Exception {
        String s;
        if (!settingsFile.exists()) {
            return false;
        }
        FileReader filereader = new FileReader(settingsFile);
        BufferedReader bufferedreader = new BufferedReader(filereader);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while ((s = bufferedreader.readLine()) != null) {
            String[] astring = ProfileManager.splitKeyValue(s);
            String s1 = astring[0];
            String s2 = "";
            if (astring.length > 1) {
                s2 = astring[1];
            }
            map.put(s1, s2);
            ++i;
        }
        ProfileManager.setProfileSet(theProfile, set, map);
        return i != 0;
    }

    private static synchronized boolean loadLegacySettings(String settingStr, JsonObject theProfile, String set) throws Exception {
        String s;
        StringReader stringreader = new StringReader(settingStr);
        BufferedReader bufferedreader = new BufferedReader(stringreader);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while ((s = bufferedreader.readLine()) != null) {
            String[] astring = ProfileManager.splitKeyValue(s);
            String s1 = astring[0];
            String s2 = "";
            if (astring.length > 1) {
                s2 = astring[1];
            }
            map.put(s1, s2);
            ++i;
        }
        ProfileManager.setProfileSet(theProfile, set, map);
        return i != 0;
    }

    private static synchronized boolean loadLegacySettings(String[] settingStr, JsonObject theProfile, String set) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        for (String s : settingStr) {
            if (s == null) continue;
            String[] astring = ProfileManager.splitKeyValue(s);
            String s1 = astring[0];
            String s2 = "";
            if (astring.length > 1) {
                s2 = astring[1];
            }
            map.put(s1, s2);
            ++i;
        }
        ProfileManager.setProfileSet(theProfile, set, map);
        return i != 0;
    }

    public static synchronized Map<String, String> getProfileSet(String profile, String set) {
        JsonObject JsonObject2;
        HashMap<String, String> map = new HashMap<String, String>();
        if (profiles.has(profile) && (JsonObject2 = profiles.get(profile).getAsJsonObject()).has(set)) {
            JsonObject JsonObject1 = JsonObject2.get(set).getAsJsonObject();
            for (String s : JsonObject1.keySet()) {
                String s1 = JsonObject1.get(s).getAsString();
                map.put(s, s1);
            }
        }
        return map;
    }

    public static synchronized Map<String, String> getProfileSet(JsonObject theProfile, String set) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (theProfile.has(set)) {
            JsonObject JsonObject2 = theProfile.get(set).getAsJsonObject();
            for (String s : JsonObject2.keySet()) {
                String s1 = JsonObject2.get(s).getAsString();
                map.put(s, s1);
            }
        }
        return map;
    }

    public static synchronized void setProfileSet(String profile, String set, Map<String, String> settings) {
        JsonObject JsonObject2 = null;
        JsonObject JsonObject1 = new JsonObject();
        if (profiles.has(profile)) {
            JsonObject2 = profiles.get(profile).getAsJsonObject();
        } else {
            JsonObject2 = new JsonObject();
            profiles.add(profile, (JsonElement)JsonObject2);
        }
        for (String s : settings.keySet()) {
            String s1 = settings.get(s);
            JsonObject1.add(s, (JsonElement)new JsonPrimitive(s1));
        }
        JsonObject2.remove(set);
        JsonObject2.add(set, (JsonElement)JsonObject1);
    }

    public static synchronized void setProfileSet(JsonObject theProfile, String set, Map<String, String> settings) {
        JsonObject JsonObject2 = new JsonObject();
        for (String s : settings.keySet()) {
            String s1 = settings.get(s);
            JsonObject2.add(s, (JsonElement)new JsonPrimitive(s1));
        }
        theProfile.remove(set);
        theProfile.add(set, (JsonElement)JsonObject2);
    }

    public static synchronized void save() {
        try {
            OutputStreamWriter outputstreamwriter = new OutputStreamWriter((OutputStream)new FileOutputStream(vrProfileCfgFile), "UTF-8");
            String s = gson.toJson((JsonElement)jsonConfigRoot);
            outputstreamwriter.write(s);
            outputstreamwriter.flush();
            outputstreamwriter.close();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public static synchronized boolean profileExists(String profileName) {
        return profiles.has(profileName);
    }

    public static synchronized SortedSet<String> getProfileList() {
        Set set = profiles.keySet();
        return new TreeSet<String>(set);
    }

    private static JsonObject getCurrentProfile() {
        if (!profiles.has(currentProfileName)) {
            return null;
        }
        JsonElement object = profiles.get(currentProfileName);
        return object != null && object instanceof JsonObject ? (JsonObject)object : null;
    }

    public static synchronized String getCurrentProfileName() {
        return currentProfileName;
    }

    public static synchronized boolean setCurrentProfile(String profileName, StringBuilder error) {
        if (!profiles.has(profileName)) {
            error.append("Profile '" + profileName + "' not found.");
            return false;
        }
        currentProfileName = profileName;
        jsonConfigRoot.add(KEY_SELECTED_PROFILE, (JsonElement)new JsonPrimitive(currentProfileName));
        return true;
    }

    public static synchronized boolean createProfile(String profileName, StringBuilder error) {
        if (profiles.has(profileName)) {
            error.append("Profile '" + profileName + "' already exists.");
            return false;
        }
        JsonObject JsonObject2 = new JsonObject();
        profiles.add(profileName, (JsonElement)JsonObject2);
        return true;
    }

    public static synchronized boolean renameProfile(String existingProfileName, String newProfileName, StringBuilder error) {
        if (existingProfileName.equals(DEFAULT_PROFILE)) {
            error.append("Cannot rename Default profile.");
            return false;
        }
        if (!profiles.has(existingProfileName)) {
            error.append("Profile '" + existingProfileName + "' not found.");
            return false;
        }
        if (profiles.has(newProfileName)) {
            error.append("Profile '" + newProfileName + "' already exists.");
            return false;
        }
        JsonObject JsonObject2 = profiles.get(existingProfileName).getAsJsonObject().deepCopy();
        profiles.remove(existingProfileName);
        profiles.add(newProfileName, (JsonElement)JsonObject2);
        if (existingProfileName.equals(currentProfileName)) {
            ProfileManager.setCurrentProfile(newProfileName, error);
        }
        return true;
    }

    public static synchronized boolean duplicateProfile(String profileName, String duplicateProfileName, StringBuilder error) {
        if (!profiles.has(profileName)) {
            error.append("Profile '" + profileName + "' not found.");
            return false;
        }
        if (profiles.has(duplicateProfileName)) {
            error.append("Profile '" + duplicateProfileName + "' already exists.");
            return false;
        }
        JsonObject JsonObject2 = profiles.get(profileName).getAsJsonObject().deepCopy();
        profiles.add(duplicateProfileName, (JsonElement)JsonObject2);
        return true;
    }

    public static synchronized boolean deleteProfile(String profileName, StringBuilder error) {
        if (profileName.equals(DEFAULT_PROFILE)) {
            error.append("Cannot delete Default profile.");
            return false;
        }
        if (!profiles.has(profileName)) {
            error.append("Profile '" + profileName + "' not found.");
            return false;
        }
        profiles.remove(profileName);
        if (profileName.equals(currentProfileName)) {
            ProfileManager.setCurrentProfile(DEFAULT_PROFILE, error);
        }
        return true;
    }

    public static void loadControllerDefaults() {
        JsonObject JsonObject2;
        if (loaded && (JsonObject2 = ProfileManager.getCurrentProfile()) != null) {
            try {
                ProfileManager.loadLegacySettings(DEFAULT_BINDINGS, JsonObject2, PROFILE_SET_CONTROLLER_BINDINGS);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String[] splitKeyValue(String s) {
        return s.split(":", 2);
    }
}

