/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import mod.chiselsandbits.api.IgnoreBlockLogic;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityAnalysisResult;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.chiseling.eligibility.BlockEligibilityAnalysisData;
import mod.chiselsandbits.chiseling.eligibility.EligibilityAnalysisResult;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModTags;
import mod.chiselsandbits.stateinfo.additional.StateVariantManager;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2404;
import net.minecraft.class_2490;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_4262;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class EligibilityManager
implements IEligibilityManager {
    private static final EligibilityManager INSTANCE = new EligibilityManager();
    private static final SimpleMaxSizedCache<IBlockInformation, IEligibilityAnalysisResult> cache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204());

    private EligibilityManager() {
    }

    public static EligibilityManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull IBlockInformation blockInformation) {
        return cache.get(blockInformation, () -> {
            if (blockInformation.getBlockState().method_26204() instanceof ChiseledBlock) {
                return new EligibilityAnalysisResult(false, true, LocalStrings.ChiselSupportIsAlreadyChiseled.getText());
            }
            if (blockInformation.getVariant().isPresent()) {
                return new EligibilityAnalysisResult(true, false, LocalStrings.ChiselSupportLogicIgnored.getText());
            }
            class_2248 blk = blockInformation.getBlockState().method_26204();
            if (blockInformation.getBlockState().method_26164(ModTags.Blocks.BLOCKED_CHISELABLE)) {
                return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportTagBlackListed, new Object[0]));
            }
            if (blockInformation.getBlockState().method_26164(ModTags.Blocks.FORCED_CHISELABLE)) {
                return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportTagWhitelisted, new Object[0]));
            }
            try {
                ReflectionHelperBlock pb = (ReflectionHelperBlock)((Object)((Object)ModBlocks.REFLECTION_HELPER_BLOCK.get()));
                Class<?> blkClass = blk.getClass();
                pb.method_9560(blockInformation.getBlockState(), null);
                Class<?> wc = ClassUtils.getDeclaringClass(blkClass, pb.getLastInvokedThreadLocalMethodName(), class_2680.class, class_47.class_48.class);
                boolean quantityDroppedTest = wc == class_2248.class || wc == class_4970.class || wc == class_2404.class;
                boolean isNotSlab = class_1792.method_7867((class_2248)blk) != class_1802.field_8162 || blockInformation.getBlockState().method_26204() instanceof class_2404;
                boolean itemExistsOrNotSpecialDrops = quantityDroppedTest || isNotSlab;
                pb.method_9530(null, null, null, null);
                Class<?> collisionClass = ClassUtils.getDeclaringClass(blkClass, pb.getLastInvokedThreadLocalMethodName(), class_2680.class, class_1922.class, class_2338.class, class_3726.class);
                boolean noCustomCollision = collisionClass == class_2248.class || collisionClass == class_4970.class || blk.getClass() == class_2490.class || collisionClass == class_2404.class;
                boolean isFullBlock = blockInformation.getBlockState().method_26225() || blk instanceof class_4262 || blk instanceof class_2404;
                BlockEligibilityAnalysisData info = BlockEligibilityAnalysisData.createFromState(blockInformation);
                boolean tickingBehavior = blk.method_9542(blockInformation.getBlockState()) && IServerConfiguration.getInstance().getBlackListRandomTickingBlocks().get() != false;
                boolean hasBehavior = blk instanceof class_2343 || tickingBehavior;
                class_3614 remappedMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockInformation.getBlockState().method_26207());
                boolean supportedMaterial = ModBlocks.MATERIAL_TO_BLOCK_CONVERSIONS.containsKey(remappedMaterial);
                if (!supportedMaterial) {
                    return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
                }
                if (blkClass.isAnnotationPresent(IgnoreBlockLogic.class)) {
                    isFullBlock = true;
                    noCustomCollision = true;
                    hasBehavior = false;
                    itemExistsOrNotSpecialDrops = true;
                }
                if (info.isCompatible() && noCustomCollision && info.getHardness() >= -0.01f && isFullBlock && supportedMaterial && !hasBehavior && itemExistsOrNotSpecialDrops) {
                    return new EligibilityAnalysisResult(true, false, TranslationUtils.build(blkClass.isAnnotationPresent(IgnoreBlockLogic.class) ? LocalStrings.ChiselSupportLogicIgnored : LocalStrings.ChiselSupportGenericSupported, new Object[0]));
                }
                if (!blockInformation.getBlockState().method_26227().method_15769() && blockInformation.getBlockState().method_26204() instanceof class_2404) {
                    return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericFluidSupport, new Object[0]));
                }
                EligibilityAnalysisResult result = null;
                if (!info.isCompatible()) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCompatDeactivated, new Object[0]));
                } else if (!noCustomCollision) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCustomCollision, new Object[0]));
                } else if (info.getHardness() < -0.01f) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNoHardness, new Object[0]));
                } else if (!isNotSlab) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportIsSlab, new Object[0]));
                } else if (!isFullBlock) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNotFullBlock, new Object[0]));
                } else if (hasBehavior) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasBehaviour, new Object[0]));
                } else if (!quantityDroppedTest) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasCustomDrops, new Object[0]));
                }
                return result;
            }
            catch (Throwable t) {
                return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportFailureToAnalyze, new Object[0]));
            }
        });
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull class_1799 provider) {
        class_1792 item = provider.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return this.analyse(new BlockInformation(blockItem.method_7711().method_9564(), StateVariantManager.getInstance().getStateVariant(blockItem.method_7711().method_9564(), provider)));
        }
        return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
    }
}

